/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.heartbeat;

import com.tridium.cloudLink.channel.BHeartbeatChannel;
import com.tridium.cloudLink.heartbeat.BHeartbeatPolicy;
import com.tridium.cloudLink.msg.ISendHeartbeatHandler;
import com.tridium.cloudLink.msg.SendHeartbeatResult;
import com.tridium.cloudLink.transport.BAbstractConnectedTransport;
import com.tridium.cloudLink.transport.BAbstractTransport;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeMinutes(5)))", override=true)
public class BForgeHeartbeatPolicy
extends BHeartbeatPolicy {
    public static final Property executionTime = BForgeHeartbeatPolicy.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)5))), null);
    public static final Type TYPE = Sys.loadType(BForgeHeartbeatPolicy.class);
    private int timeoutCount;
    private int reconnectCount;
    private long reconnectTime;
    private static final long FOUR_MINUTES_IN_SECONDS = 240L;

    public Type getType() {
        return TYPE;
    }

    public void doExecute() {
        CompletableFuture future = null;
        long timeout = this.getTimeoutSec();
        try {
            future = this.getContainer().getChannel().heartbeat((BHeartbeatPolicy)this);
            if (((SendHeartbeatResult)future.get(timeout, TimeUnit.SECONDS)).isSuccess()) {
                this.executeOk();
            } else {
                this.executeFail("Device Heartbeat task failed");
            }
        }
        catch (ExecutionException exExcept) {
            Throwable cause = exExcept.getCause();
            log.log(Level.INFO, "Device Heartbeat send task failed with exception ", log.isLoggable(Level.FINEST) ? cause : null);
            this.executeFail(exExcept.getLocalizedMessage());
        }
        catch (InterruptedException interExcept) {
            log.warning("Device Heartbeat send task was interrupted");
            this.executeFail("Device Heartbeat send task was interrupted");
        }
        catch (TimeoutException ex) {
            BAbstractTransport transport;
            log.warning(() -> String.format("Device Heartbeat send task timed out, no response after %s seconds", timeout));
            future.cancel(true);
            BHeartbeatChannel channel = this.getContainer().getChannel();
            if (++this.timeoutCount > channel.getTimeoutThreshold() && (transport = channel.getChannelConfig().getTransport(ISendHeartbeatHandler.getOperationId())) instanceof BAbstractConnectedTransport) {
                log.fine("exceeded threshold for heartbeat timeouts, reconnecting.");
                ((BAbstractConnectedTransport)transport).reconnect();
                this.timeoutCount = 0;
                ++this.reconnectCount;
                this.reconnectTime = BAbsTime.now().getMillis();
            }
            this.executeFail("Device Heartbeat send task timed out");
        }
        catch (Exception except) {
            log.warning(() -> String.format("Device Heartbeat send task failed: %s", except));
            this.executeFail(except.getLocalizedMessage());
        }
    }

    public Map<String, Object> getPayloadProperties() {
        return Collections.singletonMap("SystemTime", BAbsTime.now().encodeToString());
    }

    public void executeOk() {
        this.timeoutCount = 0;
        super.executeOk();
    }

    private long getTimeoutSec() {
        if (this.getExecutionTime().getNextTrigger().equals((Object)BAbsTime.END_OF_TIME)) {
            return 240L;
        }
        return (this.getExecutionTime().getNextTrigger().getMillis() - BAbsTime.now().getMillis()) / 4000L * 3L;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Forge Heartbeat Policy");
        out.prop((Object)"Heartbeat timeout seconds", (double)this.getTimeoutSec());
        out.prop((Object)"Heartbeat timeouts", this.timeoutCount);
        out.prop((Object)"Timeout threshold", this.getContainer().getChannel().getTimeoutThreshold());
        out.prop((Object)"Timeout based reconnect attempts", this.reconnectCount);
        out.prop((Object)"Last reconnect attempt time", (Object)BAbsTime.make((long)this.reconnectTime).encodeToString());
        out.endProps();
        super.spy(out);
    }
}

