/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.ICloudLinkMessageHandler;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.channel.BCommandsChannel;
import com.tridium.cloudLink.command.BWritePointCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.msg.IForgePointWriteCommandHandler;
import com.tridium.cloudLink.msg.IPointWriteCommandHandler;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.MessageWrapper;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.io.IOException;
import java.security.AccessController;
import java.util.concurrent.CompletableFuture;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeWritePointCommand
extends BWritePointCommand
implements BIForgeCommand {
    public static final Type TYPE = Sys.loadType(BForgeWritePointCommand.class);
    public static final String COMMAND = "PointWriteCommand";
    public static final String VERSION = "1";

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "PointWriteCommand.1";
    }

    @Override
    public String getCommandName() {
        return COMMAND;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public ICloudLinkMessageHandler<Boolean> getErrorResponse(BAbstractCloudLinkHandlerFactory msgFactory, BChannelConfig channelConfig, String commandId, int code, String message) {
        IForgePointWriteCommandHandler handler = (IForgePointWriteCommandHandler)msgFactory.getMessageHandler(IForgePointWriteCommandHandler.class, channelConfig);
        handler.addError(code, message);
        handler.setCorrelationId(commandId);
        return handler;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        String pointId = JSONUtil.getString((JSONObject)data, (String)"PointId");
        Object value = data.get("Value");
        String callingIdentity = JSONUtil.getString((JSONObject)data, (String)"CallingIdentity");
        boolean result = this.writePoint(messageId, pointId, value, 0, null, callingIdentity, cx);
        BCommandsChannel channel = this.getChannel();
        if (channel == null) {
            future.completeExceptionally(new IOException("no channel"));
            return future;
        }
        BChannelConfig config = channel.getChannelConfig();
        BAbstractTransport transport = config.getTransport(IPointWriteCommandHandler.getOperationId());
        if (!transport.canSend()) {
            log.warning("unable to send command response transport down " + messageId);
            future.completeExceptionally(new IOException("transport down"));
            return future;
        }
        BAbstractCloudLinkHandlerFactory msgFactory = (BAbstractCloudLinkHandlerFactory)((BCloudConnectionService)channel.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service."))).getMessageHandlerFactory(channel.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        IForgePointWriteCommandHandler handler = (IForgePointWriteCommandHandler)msgFactory.getMessageHandler(IForgePointWriteCommandHandler.class, config);
        handler.add(result);
        handler.setCorrelationId(messageId);
        MessageWrapper wrapper = new MessageWrapper(handler.toMessage(), handler.getFuture(future), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            config.enqueueMessage(IPointWriteCommandHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return future;
    }
}

