/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.command;

import com.tridium.cloudLink.command.BCustomCommand;
import com.tridium.cloudLink.forge.command.BForgeCommandContainer;
import com.tridium.cloudLink.forge.command.BIForgeCommand;
import com.tridium.cloudLink.forge.command.ForgeCommandDataEvent;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BForgeCustomCommandSystemCommand
extends BCustomCommand
implements BIForgeCommand {
    public static final Type TYPE = Sys.loadType(BForgeCustomCommandSystemCommand.class);
    public static final String COMMAND = "SystemCommand";
    public static final String VERSION = "1";

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setCommandId(this.getCommandName());
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BForgeCommandContainer;
    }

    @Override
    public String getRoute() {
        return "SystemCommand.1";
    }

    @Override
    public String getCommandName() {
        return this.getCustomCommand().getCommandName();
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public CompletableFuture<Boolean> execute(String messageId, JSONObject data, Context cx) {
        int code;
        String payloadString = data.has("CommandParameters") ? data.getJSONObject("CommandParameters").optString("CommandPayload", "{}") : "{}";
        JSONObject payload = new JSONObject(payloadString);
        Map<String, Object> parameters = this.parseJsonObject(payload);
        JSONObject body = new JSONObject();
        try {
            JSONObject results = new JSONObject(this.execute(messageId, parameters, cx));
            body.put("ReturnValue", (Object)results);
            body.put("ResponseCode", 200);
            body.put("ErrorMessage", (Object)"Status: OK");
            code = 200;
        }
        catch (PermissionException pEx) {
            log.warning(String.format("Insufficient permissions to execute command: %s %s", pEx.getMessage(), messageId));
            body.put("ResponseCode", 403);
            body.put("ErrorMessage", (Object)"Error: Access Not Allowed");
            code = 403;
        }
        catch (Exception ex) {
            log.warning(String.format("Failed to execute command: %s, %s", ex.getMessage(), messageId));
            body.put("ResponseCode", 400);
            body.put("ErrorMessage", (Object)"Error: Bad Request");
            code = 400;
        }
        BForgeCommandContainer container = (BForgeCommandContainer)this.getParent().as(BForgeCommandContainer.class);
        return container.sendDataEvent(new ForgeCommandDataEvent(messageId, code, body));
    }

    private Map<String, Object> parseJsonObject(JSONObject data) {
        HashMap<String, Object> rv = new HashMap<String, Object>();
        Iterator it = data.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = data.get(key);
            if (value instanceof JSONObject) {
                rv.put(key, this.parseJsonObject((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                rv.put(key, this.parseJsonArray((JSONArray)value));
                continue;
            }
            rv.put(key, value);
        }
        return rv;
    }

    private List<Object> parseJsonArray(JSONArray data) {
        ArrayList<Object> rv = new ArrayList<Object>(data.length());
        for (int lcv = 0; lcv < data.length(); ++lcv) {
            Object value = data.get(lcv);
            if (value instanceof JSONObject) {
                rv.add(this.parseJsonObject((JSONObject)value));
                continue;
            }
            if (value instanceof JSONArray) {
                rv.add(this.parseJsonArray((JSONArray)value));
                continue;
            }
            rv.add(value);
        }
        return rv;
    }
}

