/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.channel;

import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.auth.BAbstractClientAuthenticator;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BAbstractModelChannelConfig;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.channel.BModelChannel;
import com.tridium.cloudLink.channel.BTransportConfig;
import com.tridium.cloudLink.file.IUploadChannelConfig;
import com.tridium.cloudLink.forge.auth.BAbstractForgeAuthenticator;
import com.tridium.cloudLink.forge.channel.IForgeChannelConfig;
import com.tridium.cloudLink.forge.model.BModelIdSourceState;
import com.tridium.cloudLink.model.BComponentExportPolicy;
import com.tridium.cloudLink.model.BModelExportPolicyContainer;
import com.tridium.cloudLink.msg.IEndFileUploadHandler;
import com.tridium.cloudLink.msg.ISendModelCloseHandler;
import com.tridium.cloudLink.msg.ISendModelEntitiesHandler;
import com.tridium.cloudLink.msg.ISendModelOpenHandler;
import com.tridium.cloudLink.msg.IStartFileUploadHandler;
import com.tridium.json.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.job.BJob;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="httpTransport", type="BTransportConfig", defaultValue="new BTransportConfig(CLOUD_LINK_TRANSPORT_HTTP, AUTH_PLATFORM_TYPE_RPK, FILE_UPLOAD_DEFAULT_MESSAGE_SIZE)", flags=1), @NiagaraProperty(name="uploadModelFiles", type="BBoolean", defaultValue="BBoolean.TRUE"), @NiagaraProperty(name="deleteModelFiles", type="BBoolean", defaultValue="BBoolean.TRUE"), @NiagaraProperty(name="modelFileUploadTimeout", type="BRelTime", defaultValue="BRelTime.makeMinutes(15)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeMinutes(15)"), @Facet(name="BFacets.MAX", value="BRelTime.makeHours(1)")}), @NiagaraProperty(name="pointIdSource", type="BModelIdSourceState", defaultValue="BModelIdSourceState.DEFAULT", flags=4), @NiagaraProperty(name="exportId", type="BInteger", defaultValue="BInteger.DEFAULT", flags=4), @NiagaraProperty(name="connectionInfoName", type="BString", defaultValue="BString.make(IOT_HUB_2_SERVICE)", flags=5)})
public class BForgeModelChannelConfig
extends BAbstractModelChannelConfig
implements IForgeChannelConfig,
IUploadChannelConfig {
    public static final Property httpTransport = BForgeModelChannelConfig.newProperty((int)1, (BValue)new BTransportConfig("HTTP", "RpkAuthenticator", 5000000), null);
    public static final Property uploadModelFiles = BForgeModelChannelConfig.newProperty((int)0, (boolean)((BBoolean)BBoolean.TRUE.as(BBoolean.class)).getBoolean(), null);
    public static final Property deleteModelFiles = BForgeModelChannelConfig.newProperty((int)0, (boolean)((BBoolean)BBoolean.TRUE.as(BBoolean.class)).getBoolean(), null);
    public static final Property modelFileUploadTimeout = BForgeModelChannelConfig.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)15), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)15)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeHours((int)1))));
    public static final Property pointIdSource = BForgeModelChannelConfig.newProperty((int)4, (BValue)BModelIdSourceState.DEFAULT, null);
    public static final Property exportId = BForgeModelChannelConfig.newProperty((int)4, (int)((BInteger)BInteger.DEFAULT.as(BInteger.class)).getInt(), null);
    public static final Property connectionInfoName = BForgeModelChannelConfig.newProperty((int)5, (BValue)BString.make((String)"IoTHub2"), null);
    public static final Type TYPE = Sys.loadType(BForgeModelChannelConfig.class);
    private static final String CHANNEL_CONFIG_STRING = "Model Channel Config: HTTP";
    public static final String PRODUCT_TYPE_FORGE = "Forge Connect";
    public static final String PRODUCT_TYPE_NIAGARA = "Niagara Cloud Link";
    public static final String MODEL_VERSION = "1.1.0";
    public static final String CUSTOMER_ID_PROP = "customerId";
    public static final String DEFAULT_CUSTOMER_ID = "Tridium Default Customer";
    protected static final Logger log = Logger.getLogger("cloudLink.channel.model");
    protected static final String INVALID_AUTH_TYPE = "Invalid authenticator configured";
    private static final String NCS_MODEL_CHANNEL_CONFIG_TYPE = "cloudLinkNcs:NcsModelChannelConfig";

    public BTransportConfig getHttpTransport() {
        return (BTransportConfig)this.get(httpTransport);
    }

    public void setHttpTransport(BTransportConfig v) {
        this.set(httpTransport, (BValue)v, null);
    }

    public boolean getUploadModelFiles() {
        return this.getBoolean(uploadModelFiles);
    }

    public void setUploadModelFiles(boolean v) {
        this.setBoolean(uploadModelFiles, v, null);
    }

    public boolean getDeleteModelFiles() {
        return this.getBoolean(deleteModelFiles);
    }

    public void setDeleteModelFiles(boolean v) {
        this.setBoolean(deleteModelFiles, v, null);
    }

    public BRelTime getModelFileUploadTimeout() {
        return (BRelTime)this.get(modelFileUploadTimeout);
    }

    public void setModelFileUploadTimeout(BRelTime v) {
        this.set(modelFileUploadTimeout, (BValue)v, null);
    }

    public BModelIdSourceState getPointIdSource() {
        return (BModelIdSourceState)this.get(pointIdSource);
    }

    public void setPointIdSource(BModelIdSourceState v) {
        this.set(pointIdSource, (BValue)v, null);
    }

    public int getExportId() {
        return this.getInt(exportId);
    }

    public void setExportId(int v) {
        this.setInt(exportId, v, null);
    }

    public String getConnectionInfoName() {
        return this.getString(connectionInfoName);
    }

    public void setConnectionInfoName(String v) {
        this.setString(connectionInfoName, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void added(Property property, Context context) {
        if ("policySwap".equals(property.getName()) && this.get(property) == BBoolean.TRUE) {
            this.getChannel().ifPresent(c -> {
                BModelExportPolicyContainer container = ((BModelChannel)c).getPolicies();
                BComponentExportPolicy[] policies = (BComponentExportPolicy[])container.getChildren(BComponentExportPolicy.class);
                if (policies.length > 0) {
                    container.remove((BComplex)policies[0]);
                }
            });
        }
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        BTransportConfig httpTransportConfig = this.getHttpTransport();
        BFacets httpMaxMsgSizeFacets = httpTransportConfig.getSlotFacets((Slot)BTransportConfig.maxMessageSize);
        httpTransportConfig.setFacets((Slot)BTransportConfig.maxMessageSize, BFacets.make((BFacets)httpMaxMsgSizeFacets, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1000000))));
    }

    public String getPlatformType() {
        return "Forge";
    }

    public void validateConfiguration(String prefix, StringBuilder err) {
        super.validateConfiguration(prefix, err);
        if (!(this.getAuthenticator(this.getHttpTransport()) instanceof BAbstractForgeAuthenticator)) {
            log.info(() -> String.format("%s: Model channel %s", prefix, INVALID_AUTH_TYPE));
            err.append(INVALID_AUTH_TYPE).append(';');
        }
    }

    @Override
    public String getSystemGuid() {
        BAbstractForgeAuthenticator auth = (BAbstractForgeAuthenticator)this.getAuthenticator(this.getHttpTransport()).as(BAbstractForgeAuthenticator.class);
        return auth.getSystemGuid();
    }

    public String getSystemType() {
        BAbstractForgeAuthenticator auth = (BAbstractForgeAuthenticator)this.getAuthenticator(this.getHttpTransport()).as(BAbstractForgeAuthenticator.class);
        return auth.getSystemType();
    }

    public String getSystemId() {
        BAbstractForgeAuthenticator auth = (BAbstractForgeAuthenticator)this.getAuthenticator(this.getHttpTransport()).as(BAbstractForgeAuthenticator.class);
        return auth.getSystemId();
    }

    public String getVersion() {
        return Sys.getBajaVersion().toString();
    }

    public boolean getUploadToCloud() {
        return this.getUploadModelFiles();
    }

    public boolean getSaveToFile() {
        return !this.getDeleteModelFiles();
    }

    protected void registerOps() {
        this.operationMap.clear();
        this.operationMap.put(IEndFileUploadHandler.getOperationId(), this.getHttpTransport());
        this.operationMap.put(ISendModelOpenHandler.getOperationId(), this.getHttpTransport());
        this.operationMap.put(ISendModelEntitiesHandler.getOperationId(), this.getHttpTransport());
        this.operationMap.put(ISendModelCloseHandler.getOperationId(), this.getHttpTransport());
        this.operationMap.put(IStartFileUploadHandler.getOperationId(), this.getHttpTransport());
    }

    public CompletableFuture<Map<String, Object>> openModel(BJob job, BCloudConnectionService connectionService, Map<String, Object> modelProperties) {
        this.setExportId(this.getExportId() + 1);
        modelProperties.put("adHocRelation", new HashMap());
        modelProperties.put("adHocTag", new HashMap());
        return CompletableFuture.completedFuture(modelProperties);
    }

    protected BChannelConfig checkMigration() {
        try {
            BAbstractClientAuthenticator fedIdAuth = ((BCloudConnectionService)((BAbstractClientChannel)this.getChannel().orElseThrow(() -> new IllegalStateException("No Model Channel"))).getConnectionService().orElseThrow(() -> new IllegalStateException("No Cloud Connection Service"))).getAuthenticators().getAuthenticator("FederatedIdentity");
            if (fedIdAuth != null && !NCS_MODEL_CHANNEL_CONFIG_TYPE.equals(this.getType().toString())) {
                Type t = BTypeSpec.make((String)NCS_MODEL_CHANNEL_CONFIG_TYPE).getResolvedType();
                BChannelConfig ncsConfig = (BChannelConfig)t.getInstance().as(BChannelConfig.class);
                ncsConfig.copyFrom((BComplex)this);
                return ncsConfig;
            }
        }
        catch (ModuleException | TypeException ncsNotLoaded) {
            log.warning("Could not migrate Forge Model Channel Config to NCS Model Channel Config; cloudLinkNcs-rt module not loaded");
        }
        catch (Exception failReason) {
            log.warning("Could not migrate Forge Model Channel Config to NCS Model Chanel Config: " + failReason);
        }
        return this;
    }

    public JSONObject makeModelMetadata() {
        JSONObject ctxObj = new JSONObject();
        ctxObj.put("niagaraVersion", (Object)this.getVersion());
        ctxObj.put("connectivityVersion", (Object)BCloudConnectionService.TYPE.getVendorVersion());
        ctxObj.put("systemGuid", (Object)this.getSystemGuid());
        ctxObj.put("systemType", (Object)this.getSystemType());
        ctxObj.put("stationName", (Object)Sys.getStation().getStationName());
        ctxObj.put("product", (Object)BForgeModelChannelConfig.getProductName(this.getSystemId()));
        ctxObj.put("modelTimeStamp", (Object)BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)BTimeZone.UTC).encodeToString());
        ctxObj.put("modelVersion", (Object)MODEL_VERSION);
        ctxObj.put("iteration", this.getExportId());
        return ctxObj;
    }

    public String getCustomerId() {
        Property p = this.getProperty(CUSTOMER_ID_PROP);
        if (p != null) {
            return this.get(p).toString();
        }
        return DEFAULT_CUSTOMER_ID;
    }

    private static String getProductName(String systemId) {
        String product = systemId == null || systemId.isEmpty() ? "" : (systemId.startsWith("GUID") ? PRODUCT_TYPE_FORGE : PRODUCT_TYPE_NIAGARA);
        return product;
    }

    public String toString(Context cx) {
        return CHANNEL_CONFIG_STRING;
    }
}

