/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.transport.HttpResponseMessage;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public class ForgeOcspResponse {
    private final int statusCode;
    private final SingleResp[] responses;
    private static final SingleResp[] EMPTY_RESPONSES = new SingleResp[0];

    public ForgeOcspResponse(HttpResponseMessage message, X509Certificate issuer) throws Exception {
        this.statusCode = message.getStatusCode();
        if (this.statusCode != 200) {
            this.responses = EMPTY_RESPONSES;
            return;
        }
        OCSPResp response = new OCSPResp(message.getPayload());
        Object responseObj = response.getResponseObject();
        if (response.getStatus() == 0 && responseObj instanceof BasicOCSPResp) {
            BasicOCSPResp ocspResponseData = (BasicOCSPResp)responseObj;
            ForgeOcspResponse.validateOcspSignature(ocspResponseData, issuer);
            this.responses = ocspResponseData.getResponses();
        } else {
            this.responses = EMPTY_RESPONSES;
        }
    }

    public CertificateStatus getCertStatus(CertificateID certificateID) {
        for (SingleResp resp : this.responses) {
            if (!resp.getCertID().equals((Object)certificateID)) continue;
            return resp.getCertStatus();
        }
        return new UnknownStatus();
    }

    private static void validateOcspSignature(BasicOCSPResp basicResp, X509Certificate issuer) throws Exception {
        if (!basicResp.isSignatureValid(new JcaContentVerifierProviderBuilder().build(issuer))) {
            throw new Exception("Invalid signature in OCSP response");
        }
    }

    protected final void finalize() throws Throwable {
    }
}

