/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.json.JSONObject;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;

public class ForgeDeviceAuthTokenResponse {
    protected static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private final int statusCode;
    private String deviceGuid;
    private String accessToken;
    private String apiKey;
    private BAbsTime expiration;
    private static final String ERROR_MSG_TEMPLATE = "Forge device authentication token response body is not in %s format, response body is %s";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String API_KEY = "kong_api_key";
    private static final String DEVICE_ID = "device_id";
    private static final String EXPIRATION_TIME_IN_SECONDS = "expires_in";

    public ForgeDeviceAuthTokenResponse(HttpResponseMessage message) {
        this.statusCode = message.getStatusCode();
        List headers = (List)message.getHeaders().get("content-type");
        if (headers == null || !headers.contains("application/json")) {
            log.config(() -> String.format(ERROR_MSG_TEMPLATE, "application/json", message.getBodyAsString()));
            return;
        }
        if (this.statusCode == 202) {
            log.config("Device not yet claimed");
            return;
        }
        JSONObject data = new JSONObject(message.getBodyAsString());
        this.accessToken = data.getString(ACCESS_TOKEN);
        this.expiration = BAbsTime.now().add(BRelTime.makeSeconds((int)data.getInt(EXPIRATION_TIME_IN_SECONDS)));
        this.deviceGuid = data.getString(DEVICE_ID);
        this.apiKey = data.getString(API_KEY);
        log.finest(() -> String.format("Forge device authentication token response status = %d, Device guid = %s, Expiration = %s", this.statusCode, this.deviceGuid, this.expiration));
    }

    public boolean isSuccessful() {
        return this.statusCode == 200 && this.accessToken != null && !this.accessToken.isEmpty() && this.deviceGuid != null && !this.deviceGuid.isEmpty();
    }

    public String getDeviceGuid() {
        return this.deviceGuid;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public BAbsTime getExpirationTime() {
        return this.expiration;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public int getStatusCode() {
        return this.statusCode;
    }
}

