/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ForgeDeviceAuthTokenRequest
implements IMessageBuilder {
    private final String registrationHost;
    private final String systemType;
    private final String deviceCode;
    private static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private static final String API_PATH = "/v2/device/auth/token";
    private static final String GRANT_TYPE = "grant_type";
    private static final String GRANT_TEMPLATE = "grant_type=urn:ietf:params:oauth:grant-type:device_code&client_id=%s&device_code=%s";

    public ForgeDeviceAuthTokenRequest(String server, String systemType, String deviceCode) {
        this.registrationHost = server;
        this.systemType = systemType;
        this.deviceCode = deviceCode;
    }

    public IMessage toMessage(boolean isFinal) {
        URL url;
        StringWriter stringWriter = new StringWriter();
        JSONWriter jsonSerializer = QuickJSONWriter.make((Appendable)stringWriter);
        jsonSerializer.object();
        jsonSerializer.key(GRANT_TYPE).value((Object)String.format(GRANT_TEMPLATE, this.systemType, this.deviceCode));
        jsonSerializer.endObject();
        stringWriter.flush();
        try {
            url = new URL("https://" + this.registrationHost + API_PATH);
        }
        catch (MalformedURLException ex) {
            log.log(Level.INFO, "Unable to build URL for Forge device authentication token request", log.isLoggable(Level.FINE) ? ex : null);
            return null;
        }
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending Forge device authentication token request message with correlation " + correlationId);
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, url, Collections.singletonMap("x-activity-id", correlationId)).mimeType("application/json").body(stringWriter.getBuffer().toString()).build();
    }
}

