/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ForgeCsrRenewalRequest
implements IMessageBuilder {
    private final String alias;
    private final String registrationHost;
    private final NPKCS10CertificationRequest csr;
    private static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private static final String API_PATH = "/.well-known/est/forgeedge/simplereenroll";

    public ForgeCsrRenewalRequest(String server, String alias, NPKCS10CertificationRequest csr) {
        this.registrationHost = server;
        this.alias = alias;
        this.csr = csr;
    }

    public IMessage toMessage(boolean isFinal) {
        URL url;
        String body;
        try {
            String pemEncoding = this.csr.encodeToString().replace("\r\n", "\n").trim();
            int start = pemEncoding.indexOf(10) + 1;
            int end = pemEncoding.lastIndexOf(10);
            body = pemEncoding.substring(start, end);
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Unable to serialize Forge certificate renewal csr request", log.isLoggable(Level.FINE) ? ex : null);
            return null;
        }
        try {
            url = new URL("https://" + this.registrationHost + API_PATH);
        }
        catch (MalformedURLException ex) {
            log.log(Level.INFO, "Unable to build URL for Forge certificate renewal csr request", log.isLoggable(Level.FINE) ? ex : null);
            return null;
        }
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending Forge certificate renewal csr request message with correlation " + correlationId);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("x-activity-id", correlationId);
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, url, requestHeaders).mimeType("application/pkcs10").body(body).certAlias(this.alias).build();
    }
}

