/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.json.JSONObject;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;

public class ForgeBootstrapDeviceAuthResponse {
    protected static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private final int statusCode;
    private String deviceCode;
    private String registrationKey;
    private BAbsTime expiration;
    private static final String BOOTSTRAP_ERROR_MSG_TEMPLATE = "Forge bootstrap device authentication response body is not in %s format, response body is %s";
    private static final String DEVICE_CODE = "device_code";
    private static final String DIRECT_REGISTRATION_URL = "directRegistrationUrl";
    private static final String EXPIRATION_TIME_IN_SECONDS = "expires_in";
    private static final String REGISTRATION_KEY = "registration_key";

    public ForgeBootstrapDeviceAuthResponse(HttpResponseMessage message) {
        this.statusCode = message.getStatusCode();
        List headers = (List)message.getHeaders().get("content-type");
        if (headers == null || !headers.contains("application/json")) {
            log.config(() -> String.format(BOOTSTRAP_ERROR_MSG_TEMPLATE, "application/json", message.getBodyAsString()));
            return;
        }
        JSONObject data = new JSONObject(message.getBodyAsString());
        this.deviceCode = data.getString(DEVICE_CODE);
        this.registrationKey = data.getString(REGISTRATION_KEY);
        this.expiration = BAbsTime.now().add(BRelTime.makeSeconds((int)data.getInt(EXPIRATION_TIME_IN_SECONDS)));
        log.finest(() -> String.format("Forge bootstrap device authentication response status = %d, Device Code = %s, Registration Key = %s, Expiration = %s", this.statusCode, this.deviceCode, this.registrationKey, this.expiration));
    }

    public boolean isSuccessful() {
        return this.statusCode == 201 && this.deviceCode != null && !this.deviceCode.isEmpty();
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public String getRegistrationKey() {
        return this.registrationKey;
    }

    public BAbsTime getExpirationTime() {
        return this.expiration;
    }
}

