/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ForgeBootstrapDeviceAuthRequest
implements IMessageBuilder {
    private final String registrationHost;
    private final String systemType;
    private static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private static final String API_PATH = "/v2/device/authorization";
    private static final String CLIENT_ID = "client_id";

    public ForgeBootstrapDeviceAuthRequest(String server, String systemType) {
        this.registrationHost = server;
        this.systemType = systemType;
    }

    public IMessage toMessage(boolean isFinal) {
        URL url;
        StringWriter stringWriter = new StringWriter();
        JSONWriter jsonSerializer = QuickJSONWriter.make((Appendable)stringWriter);
        jsonSerializer.object();
        jsonSerializer.key(CLIENT_ID).value((Object)this.systemType);
        jsonSerializer.endObject();
        stringWriter.flush();
        try {
            url = new URL("https://" + this.registrationHost + API_PATH);
        }
        catch (MalformedURLException ex) {
            log.log(Level.INFO, "Unable to build URL for Forge bootstrap device authentication", log.isLoggable(Level.FINE) ? ex : null);
            return null;
        }
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending Forge bootstrap device authentication message with correlation " + correlationId);
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.POST, url, Collections.singletonMap("x-activity-id", correlationId)).mimeType("application/json").body(stringWriter.getBuffer().toString()).build();
    }
}

