/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.auth.BAbstractTokenProvider;
import com.tridium.cloudLink.channel.BMessagingChannel;
import com.tridium.cloudLink.forge.auth.ForgeTokenResponse;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.HttpResponseMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.json.JSONObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="providerUrl", type="BString", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="id", type="BString", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="secret", type="BPassword", defaultValue="BPassword.DEFAULT")})
public class BForgeServiceAppTokenProvider
extends BAbstractTokenProvider {
    public static final Property providerUrl = BForgeServiceAppTokenProvider.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property id = BForgeServiceAppTokenProvider.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property secret = BForgeServiceAppTokenProvider.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BForgeServiceAppTokenProvider.class);
    private String token;
    private BAbsTime expiration = BAbsTime.DEFAULT;
    protected static final String FORGE_SSO_URL_BODY = "grant_type=client_credentials&scope=forge.access openid";
    protected static final Logger log = Logger.getLogger("cloudLink.auth.forge");

    public String getProviderUrl() {
        return this.getString(providerUrl);
    }

    public void setProviderUrl(String v) {
        this.setString(providerUrl, v, null);
    }

    public String getId() {
        return this.getString(id);
    }

    public void setId(String v) {
        this.setString(id, v, null);
    }

    public BPassword getSecret() {
        return (BPassword)this.get(secret);
    }

    public void setSecret(BPassword v) {
        this.set(secret, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Optional<String> getToken(BMessagingChannel messagingChannel) {
        if (this.expiration.getMillis() < BAbsTime.now().getMillis()) {
            if (this.canAuthenticate()) {
                log.config("Obtaining new token");
                try {
                    JSONObject tokenInfo = this.authenticate(messagingChannel, this.getId(), this.getSecret().getValue());
                    this.token = tokenInfo.getString("access_token");
                    this.expiration = BAbsTime.now().add(BRelTime.makeSeconds((int)tokenInfo.getInt("expires_in")));
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, ex.getMessage(), log.isLoggable(Level.FINE) ? ex : null);
                    this.token = null;
                }
            } else {
                this.token = null;
            }
        }
        return Optional.ofNullable(this.token);
    }

    public boolean canAuthenticate() {
        return !this.getId().isEmpty() && !this.getSecret().isDefault() && !this.getProviderUrl().isEmpty();
    }

    private JSONObject authenticate(BMessagingChannel messagingChannel, String clientId, String clientSecret) throws InterruptedException, ExecutionException, TimeoutException, MalformedURLException {
        String ssoUrl = this.getProviderUrl();
        String credentials = clientId + ':' + clientSecret;
        String ssoBody = FORGE_SSO_URL_BODY;
        Map<String, Object> headers = Collections.singletonMap("Authorization", "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8)));
        ForgeTokenResponse appToken = BForgeServiceAppTokenProvider.communicateViaTransport(messagingChannel, HttpRequestMessage.HttpMethod.POST, ssoUrl, "application/x-www-form-urlencoded", ssoBody, headers);
        return appToken.getTokenInfo();
    }

    private static ForgeTokenResponse communicateViaTransport(BMessagingChannel messagingChannel, HttpRequestMessage.HttpMethod methodType, String uri, String mimeType, String body, Map<String, Object> headers) throws MalformedURLException, InterruptedException, ExecutionException, TimeoutException {
        log.config("Looking for messaging channel");
        if (messagingChannel == null || !messagingChannel.isOperational()) {
            log.info("Messaging channel was not detected.");
            throw new RuntimeException("Messaging channel not found");
        }
        log.config("Messaging channel was detected.");
        CompletableFuture sysConnFuture = new CompletableFuture();
        HttpRequestMessage sysConnRequest = new HttpRequestMessage.HttpRequestMessageBuilder(methodType, new URL(uri), headers).mimeType(mimeType).body(body).build();
        CompletableFuture reqFuture = AccessController.doPrivileged(() -> messagingChannel.sendAsync("HTTP", (IMessage)sysConnRequest));
        reqFuture.whenComplete((resp, err) -> {
            if (err != null) {
                sysConnFuture.completeExceptionally((Throwable)err);
            } else {
                try (HttpResponseMessage httpResp = (HttpResponseMessage)resp;){
                    ForgeTokenResponse response = new ForgeTokenResponse(httpResp.getStatusCode(), httpResp.getBodyAsString());
                    sysConnFuture.complete(response);
                }
                catch (Exception ex) {
                    sysConnFuture.completeExceptionally(ex);
                }
            }
        });
        ForgeTokenResponse forgeResponse = (ForgeTokenResponse)sysConnFuture.get(messagingChannel.getChannelConfig().getTransport("HTTP").getDefaultMessageTimeout().getMillis(), TimeUnit.MILLISECONDS);
        return forgeResponse;
    }
}

