/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AzureDpsRegisterCertRequest
implements IMessageBuilder {
    private final String registrationHost;
    private final String alias;
    private final String scope;
    private final String systemGuid;
    private static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private static final String ACCEPT = "Accept";
    private static final String API_PATH = "/%s/registrations/%s/register?api-version=2019-03-31";
    private static final String REGISTRATION_ID = "registrationId";

    public AzureDpsRegisterCertRequest(String server, String alias, String scope, String systemGuid) {
        this.registrationHost = server;
        this.alias = alias;
        this.scope = scope;
        this.systemGuid = systemGuid;
    }

    public IMessage toMessage(boolean isFinal) {
        URL url;
        StringWriter stringWriter = new StringWriter();
        JSONWriter jsonSerializer = QuickJSONWriter.make((Appendable)stringWriter);
        jsonSerializer.object();
        jsonSerializer.key(REGISTRATION_ID).value((Object)this.systemGuid);
        jsonSerializer.endObject();
        stringWriter.flush();
        String urlString = "https://" + this.registrationHost + String.format(API_PATH, this.scope, this.systemGuid);
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            log.log(Level.INFO, "Unable to build URL for Azure DPS registration request url = [" + urlString + ']', log.isLoggable(Level.FINE) ? ex : null);
            return null;
        }
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending Azure DPS registration request message with correlation " + correlationId);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("x-activity-id", correlationId);
        requestHeaders.put(ACCEPT, "application/json");
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.PUT, url, requestHeaders).mimeType("application/json").body(stringWriter.getBuffer().toString()).certAlias(this.alias).build();
    }
}

