/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.forge.auth;

import com.tridium.cloudLink.msg.IMessageBuilder;
import com.tridium.cloudLink.transport.HttpRequestMessage;
import com.tridium.cloudLink.transport.IMessage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AzureDpsCheckRegistrationRequest
implements IMessageBuilder {
    private final String registrationHost;
    private final String alias;
    private final String scope;
    private final String systemGuid;
    private final String operationId;
    private static final Logger log = Logger.getLogger("cloudLink.auth.forge");
    private static final String ACCEPT = "Accept";
    private static final String API_PATH = "/%s/registrations/%s/operations/%s?api-version=2019-03-31";

    public AzureDpsCheckRegistrationRequest(String server, String alias, String scope, String systemGuid, String operationId) {
        this.registrationHost = server;
        this.alias = alias;
        this.scope = scope;
        this.systemGuid = systemGuid;
        this.operationId = operationId;
    }

    public IMessage toMessage(boolean isFinal) {
        URL url;
        String urlString = "https://" + this.registrationHost + String.format(API_PATH, this.scope, this.systemGuid, this.operationId);
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            log.log(Level.INFO, "Unable to build URL for Azure DPS registration status request url = [" + urlString + ']', log.isLoggable(Level.FINE) ? ex : null);
            return null;
        }
        String correlationId = UUID.randomUUID().toString();
        log.config(() -> "Sending Azure DPS registration status request message with correlation " + correlationId);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("x-activity-id", correlationId);
        requestHeaders.put(ACCEPT, "application/json");
        return new HttpRequestMessage.HttpRequestMessageBuilder(HttpRequestMessage.HttpMethod.GET, url, requestHeaders).certAlias(this.alias).build();
    }
}

