/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.util;

import com.tridium.cloudLink.util.IValueWrapper;
import com.tridium.nre.security.SecretChars;
import java.util.logging.Logger;
import javax.baja.security.BPassword;

public class PasswordWrapper
implements IValueWrapper<BPassword> {
    private BPassword password;
    static final Logger log = Logger.getLogger("cloudLink.util");

    public PasswordWrapper(BPassword password) {
        this.setValue(password);
    }

    @Override
    public BPassword getValue() {
        return this.password;
    }

    @Override
    public void setValue(BPassword password) {
        this.password = password;
    }

    @Override
    public Class<BPassword> getType() {
        return BPassword.class;
    }

    public static BPassword getPassword(IValueWrapper<?> wrapper) {
        if (wrapper == null) {
            log.fine("GetPassword() called with null IValueWrapper<?>.");
            return null;
        }
        if (wrapper.getType() != BPassword.class) {
            log.warning(() -> String.format("Invalid cast of IValueWrapper<%s> to IValueWrapper<BPassword>.", wrapper.getType()));
            return null;
        }
        return (BPassword)wrapper.getValue();
    }

    public static String getPasswordValue(IValueWrapper<?> wrapper) {
        BPassword password = PasswordWrapper.getPassword(wrapper);
        return password == null ? null : password.getValue();
    }

    public static SecretChars getPasswordSecretChars(IValueWrapper<?> wrapper) {
        BPassword password = PasswordWrapper.getPassword(wrapper);
        return password == null ? null : password.getSecretChars();
    }
}

