/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.util;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.baja.sys.BAbsTime;
import javax.baja.timezone.BTimeZone;

public class BearerTokenInfo {
    public static final String INVALID_JWT_FORMAT = "Invalid JWT format";
    private String stringRepresentation = "";
    private final Map<String, Object> claims = new HashMap<String, Object>();

    public BearerTokenInfo(String idjwt) {
        this.fromString(idjwt);
    }

    public boolean isTokenExpired() {
        BAbsTime expirTime = BAbsTime.make((BAbsTime)BAbsTime.make((long)((long)Integer.parseInt(String.valueOf(this.claims.get("exp"))) * 1000L), (BTimeZone)BTimeZone.UTC), (BTimeZone)BTimeZone.getLocal());
        return BAbsTime.make((long)System.currentTimeMillis()).isAfter(expirTime);
    }

    public Map<String, Object> getClaims() {
        return Collections.unmodifiableMap(this.claims);
    }

    public Object getSpecificClaim(String claim) {
        return this.claims.get(claim);
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public void fromString(String idjwt) {
        if (idjwt != null && !idjwt.isEmpty()) {
            String[] jwtParts = idjwt.split("\\.");
            if (jwtParts == null || jwtParts.length < 2) {
                this.invalid();
            } else {
                try {
                    String joseHdr = new String(Base64.getDecoder().decode(jwtParts[0]), StandardCharsets.UTF_8);
                    JSONTokener tokener = new JSONTokener((Reader)new StringReader(joseHdr));
                    JSONObject obj = new JSONObject(tokener);
                    String algorithm = JSONUtil.getString((JSONObject)obj, (String)"alg");
                    String jwtClaims = new String(Base64.getDecoder().decode(jwtParts[1]), StandardCharsets.UTF_8);
                    JSONTokener claimsTokener = new JSONTokener((Reader)new StringReader(jwtClaims));
                    obj = new JSONObject(claimsTokener);
                    Iterator keysItr = obj.keys();
                    this.claims.put("alg", algorithm);
                    while (keysItr.hasNext()) {
                        String key = (String)keysItr.next();
                        String value = JSONUtil.getString((JSONObject)obj, (String)key);
                        this.claims.put(key, value);
                    }
                    this.stringRepresentation = idjwt;
                }
                catch (Exception err) {
                    this.invalid();
                }
            }
        } else {
            this.clear();
        }
    }

    private void invalid() {
        this.clear();
        this.claims.put("alg", INVALID_JWT_FORMAT);
    }

    public void clear() {
        this.claims.clear();
        this.claims.put("alg", "");
        this.claims.put("SystemId", "");
        this.claims.put("iss", "");
        this.claims.put("aud", "");
        this.claims.put("SystemType", "");
        this.claims.put("nbf", BAbsTime.DEFAULT);
        this.claims.put("exp", BAbsTime.DEFAULT);
    }
}

