/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport.internal;

import com.tridium.cloudLink.transport.internal.AmqpSenderLinkHandler;
import com.tridium.cloudLink.transport.internal.IAmqpSessionHandler;
import com.tridium.cloudLink.util.IValueWrapper;
import com.tridium.cloudLink.util.PasswordWrapper;
import com.tridium.cloudLink.util.StringWrapper;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.Message;

public class AmqpAuthSenderLinkHandler
extends AmqpSenderLinkHandler {
    AmqpAuthSenderLinkHandler(Sender sender, IAmqpSessionHandler parent) {
        super(sender, UUID.randomUUID().toString(), parent);
        this.linkAddress = "$cbs";
    }

    UUID sendAuthenticationMessage() throws IOException {
        UUID correlationId = UUID.randomUUID();
        Message outgoingMessage = this.createAuthMessage(correlationId);
        this.sendMessage(outgoingMessage);
        return correlationId;
    }

    private Message createAuthMessage(UUID correlationId) throws IOException {
        Message message = Proton.message();
        Properties properties = new Properties();
        properties.setMessageId(correlationId);
        properties.setTo("$cbs");
        properties.setReplyTo("cbs");
        message.setProperties(properties);
        HashMap<String, Object> userProperties = new HashMap<String, Object>(3);
        userProperties.put("operation", "put-token");
        userProperties.put("type", "servicebus.windows.net:sastoken");
        Map<String, IValueWrapper<?>> connectionInfo = this.parentSessionHandler.getClient().getConnectionInfo();
        String host = StringWrapper.getString(connectionInfo.get("hostName"));
        userProperties.put("name", host + "/devices/" + StringWrapper.getString(connectionInfo.get("id")));
        ApplicationProperties applicationProperties = new ApplicationProperties(userProperties);
        message.setApplicationProperties(applicationProperties);
        String token = AccessController.doPrivileged(() -> PasswordWrapper.getPasswordValue((IValueWrapper)connectionInfo.get("token")));
        AmqpValue section = new AmqpValue(token);
        message.setBody(section);
        return message;
    }
}

