/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.transport;

import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HttpStatusException
extends IOException {
    private final int statusCode;
    private final Optional<JSONObject> body;
    private final Map<String, List<String>> headers;

    public HttpStatusException(int statusCode, String message, Map<String, List<String>> headers, JSONObject body) {
        super(message);
        this.statusCode = statusCode;
        this.body = Optional.ofNullable(body);
        this.headers = headers;
    }

    public HttpStatusException(int statusCode, String message, Map<String, List<String>> headers) {
        super(message);
        this.statusCode = statusCode;
        this.body = Optional.empty();
        this.headers = headers;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public Optional<JSONObject> getErrorBody() {
        return this.body;
    }

    @Override
    public String toString() {
        return String.format("HttpStatusException: status code: %s, headers: %s, message: %s, body: %s", this.statusCode, CloudLinkUtils.makeMultiMapString(this.headers), this.getMessage(), this.body.orElseGet(() -> new JSONObject("{}")));
    }
}

