/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.tag;

import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.tag.BPropertySuppliedTag;
import com.tridium.cloudLink.tag.condition.BIsPointProxyTypeCondition;
import com.tridium.tagdictionary.condition.BIsTypeCondition;
import com.tridium.util.CompUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.io.ValueDocDecoder;
import javax.baja.naming.BOrd;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tagdictionary.BSmartTagDictionary;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.tagdictionary.BTagRule;
import javax.baja.tagdictionary.BTagRuleCondition;
import javax.baja.util.BTypeSpec;

public final class CloudLinkTagUtil {
    public static final Predicate<Entity> entityExcludedFromModel = e -> e.tags().contains(CloudLinkConstants.EXCLUDED);
    public static final Predicate<Entity> entityIncludedInModel = entityExcludedFromModel.negate();
    public static final Predicate<Relation> relationExcludedFromModel = r -> {
        Entity entity = r.getEndpoint();
        return entityExcludedFromModel.test(entity);
    };
    public static final Predicate<Relation> relationIncludedInModel = relationExcludedFromModel.negate();
    static final Logger log = Logger.getLogger("cloudLink.tag");

    public static BSmartTagDictionary getOrAddTagDictionary(String namespace, String dictionaryLocation) {
        BTagDictionaryService tagDictionaryService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
        return (BSmartTagDictionary)tagDictionaryService.getTagDictionary(namespace).orElseGet(() -> CloudLinkTagUtil.addTagDictionary(namespace, dictionaryLocation));
    }

    public static BSmartTagDictionary addTagDictionary(String namespace, String dictionaryLocation) {
        BTagDictionaryService tagDictionaryService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
        try {
            if (dictionaryLocation.endsWith(".bog")) {
                BComponent dictFolder;
                try (ValueDocDecoder docDecoder = new ValueDocDecoder(BOrd.make((String)dictionaryLocation));){
                    dictFolder = docDecoder.decodeDocument().asComponent();
                }
                return CloudLinkTagUtil.importTagDictionaries(dictFolder, namespace);
            }
            BSmartTagDictionary smartTagDictionary = (BSmartTagDictionary)BOrd.make((String)dictionaryLocation).resolve().get();
            Mark mark = new Mark((BObject)smartTagDictionary, smartTagDictionary.getName());
            mark.copyTo((BObject)tagDictionaryService, null);
            return (BSmartTagDictionary)tagDictionaryService.getTagDictionary(namespace).orElseThrow(() -> new Exception("Unable to access dictionary after copy"));
        }
        catch (Exception e) {
            String errorMessage = String.format("Unable to load tag dictionary from %s with namespace %s", dictionaryLocation, namespace);
            log.log(Level.SEVERE, errorMessage, log.isLoggable(Level.FINE) ? e : null);
            throw new RuntimeException(errorMessage, e);
        }
    }

    private static BSmartTagDictionary importTagDictionaries(BComponent dictFolder, String namespace) throws Exception {
        BTagDictionaryService tagDictionaryService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
        for (BTagDictionary dictionary : (BTagDictionary[])CompUtil.getDescendants((BComponent)dictFolder, BTagDictionary.class)) {
            if (!dictionary.getNamespace().equals(namespace)) continue;
            Mark mark = new Mark((BObject)dictionary, dictionary.getName());
            mark.copyTo((BObject)tagDictionaryService, null);
            return (BSmartTagDictionary)tagDictionaryService.getTagDictionary(namespace).orElseThrow(() -> new Exception("Unable to access dictionary after copy"));
        }
        throw new Exception("Tag dictionary with namespace [" + namespace + "] not found");
    }

    public static BTagRule makeProxyPointTagRule(String typeSpec) {
        BIsPointProxyTypeCondition condition = new BIsPointProxyTypeCondition();
        condition.setProxyExtType(BTypeSpec.make((String)typeSpec));
        BTagRule rule = new BTagRule();
        rule.setCondition((BTagRuleCondition)condition);
        return rule;
    }

    public static BTagRule makeTagRule(String typeSpec) {
        BIsTypeCondition condition = new BIsTypeCondition();
        condition.setObjectType(BTypeSpec.make((String)typeSpec));
        BTagRule rule = new BTagRule();
        rule.setCondition((BTagRuleCondition)condition);
        return rule;
    }

    public static BPropertySuppliedTag createTag(List<String> driverSlotNames) {
        BPropertySuppliedTag tag = new BPropertySuppliedTag();
        BVector v = new BVector();
        driverSlotNames.forEach(slotName -> v.add(slotName, (BValue)BString.make((String)slotName)));
        tag.setPropertyNames(v);
        return tag;
    }

    public static BPropertySuppliedTag createTag(String separator, List<String> driverSlotNames) {
        BPropertySuppliedTag tag = new BPropertySuppliedTag();
        tag.setSeparator(separator);
        BVector v = new BVector();
        driverSlotNames.forEach(slotName -> v.add(slotName, (BValue)BString.make((String)slotName)));
        tag.setPropertyNames(v);
        return tag;
    }

    public static Optional<BIDataValue> getTelemetryId(BIEntity entity) {
        return TagUtil.getTag((BIEntity)entity, (Id)CloudLinkConstants.TELEMETRY_ID);
    }

    public static Optional<BIDataValue> getTelemetryId(BComponent component) {
        BValue value = component.get(CloudLinkConstants.ESCAPED_TELEMETRY_ID_TAG);
        if (value instanceof BIDataValue) {
            return Optional.of((BIDataValue)value);
        }
        return Optional.empty();
    }

    private CloudLinkTagUtil() {
    }
}

