/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.reverter;

import biweekly.ICalendar;
import biweekly.component.VEvent;
import biweekly.property.RawProperty;
import biweekly.property.Summary;
import biweekly.util.ByDay;
import biweekly.util.Recurrence;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.PropertyEncoder;
import com.tridium.cloudLink.schedule.reverter.DateRangeScheduleReverter;
import com.tridium.cloudLink.schedule.reverter.DateScheduleReverter;
import com.tridium.cloudLink.schedule.reverter.ICalendarReverter;
import com.tridium.cloudLink.schedule.reverter.TimeScheduleReverter;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BCustomSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.schedule.BStringSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeekAndDaySchedule;
import javax.baja.schedule.BWeekSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.util.BFormat;

public class WeeklyScheduleReverter
implements ICalendarReverter {
    private final TimeScheduleReverter timeScheduleReverter = new TimeScheduleReverter();
    private final DateScheduleReverter dateScheduleReverter = new DateScheduleReverter();
    private final DateRangeScheduleReverter dateRangeScheduleReverter = new DateRangeScheduleReverter();
    static final Logger log = Logger.getLogger("cloudLink.channel.schedule");

    @Override
    public BAbstractSchedule revert(ICalendar ical) {
        if (ical == null) {
            return null;
        }
        BWeeklySchedule schedule = this.makeWeeklyScheduleByCalType(ical);
        List<VEvent> weekdayEvents = this.getWeekdayEvents(ical);
        List<VEvent> specialEvents = this.getSpecialEvents(ical);
        this.addProperties(schedule, ical);
        this.addRange(schedule, ical);
        this.addWeekdaySchedules(schedule, weekdayEvents);
        this.addSpecialEvents(schedule, specialEvents);
        return schedule;
    }

    private void addProperties(BWeeklySchedule schedule, ICalendar ical) {
        RawProperty propScanLimit;
        BRelTime scanLimit;
        RawProperty propCleanupExpiredEvents;
        BBoolean cleanup;
        RawProperty propOutput;
        BValue defaultOutput;
        RawProperty propName;
        BValue calName;
        RawProperty propUnion;
        BBoolean union;
        RawProperty propAlwaysEffective;
        BBoolean alwaysEffective;
        RawProperty propValue = ical.getExperimentalProperty("X-TRIDIUM-NIAGARA-EFFECTIVE-VALUE");
        BValue effectiveValue = PropertyEncoder.decode(propValue);
        if (effectiveValue != null) {
            schedule.setEffectiveValue((BStatusValue)BStatusValue.make((BObject)effectiveValue));
        }
        if ((alwaysEffective = (BBoolean)PropertyEncoder.decode(propAlwaysEffective = ical.getExperimentalProperty("X-TRIDIUM-NIAGARA-ALWAYS-EFFECTIVE"))) != null) {
            schedule.setAlwaysEffective(alwaysEffective.getBoolean());
        }
        if ((union = (BBoolean)PropertyEncoder.decode(propUnion = ical.getExperimentalProperty("X-TRIDIUM-NIAGARA-UNION"))) != null) {
            schedule.setUnion(union.getBoolean());
        }
        if ((calName = PropertyEncoder.decode(propName = ical.getExperimentalProperty("X-WR-CALNAME"))) != null) {
            schedule.add("calendarName", calName);
        }
        RawProperty propFacets = ical.getExperimentalProperty("X-TRIDIUM-NIAGARA-FACETS");
        BValue facetsEncoding = PropertyEncoder.decode(propFacets);
        if (propFacets != null) {
            try {
                BFacets decodedFacets = (BFacets)BFacets.DEFAULT.decodeFromString(facetsEncoding.toString());
                schedule.setFacets(decodedFacets);
            }
            catch (IOException ex) {
                log.log(Level.INFO, "Invalid facets: " + facetsEncoding, log.isLoggable(Level.FINE) ? ex : null);
                throw new IllegalArgumentException("Invalid facets: " + facetsEncoding);
            }
        }
        if ((defaultOutput = PropertyEncoder.decode(propOutput = ical.getExperimentalProperty("X-TRIDIUM-NIAGARA-DEFAULT-OUTPUT"))) != null) {
            schedule.setDefaultOutput((BStatusValue)BStatusValue.make((BObject)defaultOutput));
        }
        if ((cleanup = (BBoolean)PropertyEncoder.decode(propCleanupExpiredEvents = ical.getExperimentalProperty("X-TRIDIUM-NIAGARA-CLEANUP-EXPIRED-EVENTS"))) != null) {
            schedule.setCleanupExpiredEvents(cleanup.getBoolean());
        }
        if ((scanLimit = (BRelTime)PropertyEncoder.decode(propScanLimit = ical.getExperimentalProperty("X-TRIDIUM-NIAGARA-SCAN-LIMIT"))) != null && scanLimit != BRelTime.DEFAULT) {
            schedule.setScanLimit(scanLimit);
        }
    }

    private void addRange(BWeeklySchedule schedule, ICalendar ical) {
        BDateSchedule rangeStart = new BDateSchedule();
        rangeStart.setYear(PropertyEncoder.getSingleton(ical.getExperimentalProperty("X-TRIDIUM-NIAGARA-RANGE-START-YEAR")));
        rangeStart.setMonth(PropertyEncoder.getSingleton(ical.getExperimentalProperty("X-TRIDIUM-NIAGARA-RANGE-START-MONTH")));
        rangeStart.setDay(PropertyEncoder.getSingleton(ical.getExperimentalProperty("X-TRIDIUM-NIAGARA-RANGE-START-DAY")));
        rangeStart.setWeekday(PropertyEncoder.getSingleton(ical.getExperimentalProperty("X-TRIDIUM-NIAGARA-RANGE-START-DAY-OF-WEEK")));
        BDateSchedule rangeEnd = new BDateSchedule();
        rangeEnd.setYear(PropertyEncoder.getSingleton(ical.getExperimentalProperty("X-TRIDIUM-NIAGARA-RANGE-END-YEAR")));
        rangeEnd.setMonth(PropertyEncoder.getSingleton(ical.getExperimentalProperty("X-TRIDIUM-NIAGARA-RANGE-END-MONTH")));
        rangeEnd.setDay(PropertyEncoder.getSingleton(ical.getExperimentalProperty("X-TRIDIUM-NIAGARA-RANGE-END-DAY")));
        rangeEnd.setWeekday(PropertyEncoder.getSingleton(ical.getExperimentalProperty("X-TRIDIUM-NIAGARA-RANGE-END-DAY-OF-WEEK")));
        BDateRangeSchedule range = new BDateRangeSchedule();
        range.setStart(rangeStart);
        range.setEnd(rangeEnd);
        schedule.setEffective(range);
    }

    private BWeeklySchedule makeWeeklyScheduleByCalType(ICalendar ical) {
        String scheduleType = ConverterUtils.getControlScheduleType(ical);
        Object schedule = CloudLinkConstants.BOOLEAN_SCHEDULE_TS.equals(scheduleType) ? new BBooleanSchedule() : (CloudLinkConstants.NUMERIC_SCHEDULE_TS.equals(scheduleType) ? new BNumericSchedule() : (CloudLinkConstants.ENUM_SCHEDULE_TS.equals(scheduleType) ? new BEnumSchedule() : new BStringSchedule()));
        return schedule;
    }

    private void addWeekdaySchedules(BWeeklySchedule schedule, List<VEvent> weeklyEvents) {
        for (VEvent event : weeklyEvents) {
            List<ByDay> dows = ((Recurrence)event.getRecurrenceRule().getValue()).getByDay();
            if (dows.size() == 1) {
                ByDay dow = dows.get(0);
                BTimeSchedule ts = (BTimeSchedule)this.timeScheduleReverter.revert(event);
                BWeekSchedule ws = (BWeekSchedule)schedule.getSchedule().get("week");
                BDaySchedule day = ws.get(BWeekday.make((int)dow.getDay().ordinal()));
                BDailySchedule combo = (BDailySchedule)day.getParent();
                day.add(ts);
                WeeklyScheduleReverter.setDisplayName(ts, (BAbstractSchedule)combo, event);
                continue;
            }
            log.log(Level.INFO, String.format("Invalid number of recurrence days (%d) for weekday schedule event '%s': ", dows.size(), event.getSummary()));
        }
    }

    private void addSpecialEvents(BWeeklySchedule schedule, List<VEvent> specialEvents) {
        BCompositeSchedule specials = schedule.getSpecialEvents();
        BAbstractSchedule[] children = specials.getSchedules();
        for (VEvent event : specialEvents) {
            Optional<String> parentName = PropertyEncoder.getPropertyValue(event.getExperimentalProperty("X-TRIDIUM-NIAGARA-PARENT"));
            if (!parentName.isPresent()) {
                log.log(Level.INFO, String.format("Event '%s' does not have property %s defined.", event.getSummary(), "X-TRIDIUM-NIAGARA-PARENT"));
                continue;
            }
            Optional<String> typeSpec = PropertyEncoder.getPropertyValue(event.getExperimentalProperty("X-TRIDIUM-NIAGARA-TYPESPEC"));
            if (!typeSpec.isPresent()) {
                log.log(Level.INFO, String.format("Event '%s' does not have property %s defined.", event.getSummary(), "X-TRIDIUM-NIAGARA-TYPESPEC"));
                continue;
            }
            BDailySchedule special = this.getSpecialEvent(parentName.get(), children, typeSpec.get(), event);
            BTimeSchedule ts = (BTimeSchedule)this.timeScheduleReverter.revert(event);
            special.getDay().add(ts);
            specials.add(parentName.get(), (BValue)special);
            WeeklyScheduleReverter.setDisplayName(ts, (BAbstractSchedule)special, event);
        }
    }

    private List<VEvent> getWeekdayEvents(ICalendar ical) {
        return ical.getEvents().stream().filter(ConverterUtils::isWeekday).collect(Collectors.toList());
    }

    private List<VEvent> getSpecialEvents(ICalendar ical) {
        return ical.getEvents().stream().filter(e -> !ConverterUtils.isWeekday(e)).collect(Collectors.toList());
    }

    private BDailySchedule getSpecialEvent(String name, BAbstractSchedule[] children, String typeSpec, VEvent event) {
        for (BAbstractSchedule s : children) {
            if (!s.getName().equals(name)) continue;
            return (BDailySchedule)s;
        }
        BDailySchedule newSchedule = new BDailySchedule();
        if (CloudLinkConstants.DATE_SCHEDULE_TS.equals(typeSpec)) {
            BAbstractSchedule dateSchedule = this.dateScheduleReverter.revert(event);
            newSchedule.setDays(dateSchedule);
        } else if (CloudLinkConstants.DATE_RANGE_SCHEDULE_TS.equals(typeSpec)) {
            BAbstractSchedule dateRangeSchedule = this.dateRangeScheduleReverter.revert(event);
            newSchedule.setDays(dateRangeSchedule);
        } else if (CloudLinkConstants.CUSTOM_SCHEDULE_TS.equals(typeSpec)) {
            newSchedule.setDays((BAbstractSchedule)new BCustomSchedule());
        } else if (CloudLinkConstants.WEEK_AND_DAY_SCHEDULE_TS.equals(typeSpec)) {
            newSchedule.setDays((BAbstractSchedule)new BWeekAndDaySchedule());
        } else if (CloudLinkConstants.SCHEDULE_REFERENCE_TS.equals(typeSpec)) {
            newSchedule.setDays((BAbstractSchedule)new BScheduleReference());
        } else {
            log.log(Level.INFO, String.format("Invalid type %s of days component defined for schedule %s: ", typeSpec, name));
        }
        return newSchedule;
    }

    private static void setDisplayName(BTimeSchedule ts, BAbstractSchedule combo, VEvent event) {
        Summary summary = event.getSummary();
        if (summary == null) {
            return;
        }
        String compositeName = (String)summary.getValue();
        if (compositeName == null || compositeName.isEmpty()) {
            return;
        }
        BasicContext cx = new BasicContext();
        String comboDisplayName = combo.getDisplayName((Context)cx);
        if (compositeName.startsWith(comboDisplayName + " ")) {
            String childName = compositeName.substring(comboDisplayName.length() + 1);
            Property parentProp = ts.getPropertyInParent();
            if (parentProp != null) {
                BAbstractSchedule parent = (BAbstractSchedule)ts.getParent();
                parent.setDisplayName(parentProp, BFormat.make((String)childName), (Context)cx);
            }
        }
    }
}

