/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.reverter;

import biweekly.component.VEvent;
import biweekly.property.RawProperty;
import biweekly.util.Duration;
import biweekly.util.ICalDate;
import com.tridium.cloudLink.schedule.converter.PropertyEncoder;
import com.tridium.cloudLink.schedule.reverter.IVEventReverter;
import java.util.Calendar;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;

public class TimeScheduleReverter
implements IVEventReverter {
    @Override
    public BAbstractSchedule revert(VEvent event) {
        RawProperty propAlwaysEffective;
        BBoolean alwaysEffective;
        ICalDate end;
        if (event == null) {
            return null;
        }
        ICalDate start = (ICalDate)event.getDateStart().getValue();
        BTime startTime = BTime.DEFAULT;
        if (start.hasTime()) {
            Calendar cals = Calendar.getInstance();
            cals.setTime(start);
            startTime = BTime.make((int)cals.get(11), (int)cals.get(12), (int)cals.get(13));
        }
        BTime endTime = BTime.DEFAULT;
        ICalDate iCalDate = end = event.getDateEnd() != null ? (ICalDate)event.getDateEnd().getValue() : null;
        if (end != null && end.hasTime()) {
            Calendar cale = Calendar.getInstance();
            cale.setTime(end);
            endTime = BTime.make((int)cale.get(11), (int)cale.get(12), (int)cale.get(13));
        } else if (event.getDuration() != null) {
            Duration duration = (Duration)event.getDuration().getValue();
            BRelTime relDuration = BRelTime.make((long)duration.toMillis());
            endTime = startTime.add(relDuration);
        }
        BTimeSchedule timeSchedule = new BTimeSchedule(startTime, endTime);
        RawProperty propValue = event.getExperimentalProperty("X-TRIDIUM-NIAGARA-EFFECTIVE-VALUE");
        BValue effectiveValue = PropertyEncoder.decode(propValue);
        if (effectiveValue != null) {
            timeSchedule.setEffectiveValue((BStatusValue)BStatusValue.make((BObject)effectiveValue));
        }
        if ((alwaysEffective = (BBoolean)PropertyEncoder.decode(propAlwaysEffective = event.getExperimentalProperty("X-TRIDIUM-NIAGARA-ALWAYS-EFFECTIVE"))) != null) {
            timeSchedule.setAlwaysEffective(alwaysEffective.getBoolean());
        }
        return timeSchedule;
    }
}

