/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.plugin;

import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.property.ICalProperty;
import biweekly.property.RawProperty;
import java.util.List;

public final class PluginUtils {
    private PluginUtils() {
    }

    @SafeVarargs
    public static void checkStandardRequired(ICalComponent component, List<ValidationWarning> warnings, Class<? extends ICalProperty> ... classes) {
        for (Class<? extends ICalProperty> clazz : classes) {
            List<? extends ICalProperty> props = component.getProperties(clazz);
            if (!props.isEmpty()) continue;
            warnings.add(new ValidationWarning(2, clazz.getSimpleName()));
        }
    }

    public static void checkExperimentalRequired(ICalComponent component, List<ValidationWarning> warnings, String ... names) {
        for (String name : names) {
            List<RawProperty> props = component.getExperimentalProperties(name);
            if (props.isEmpty()) {
                warnings.add(new ValidationWarning(2, name));
                continue;
            }
            if (props.size() <= 1) continue;
            warnings.add(new ValidationWarning(3, name));
        }
    }
}

