/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.ICalendar;
import biweekly.component.VEvent;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.PropertyEncoder;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BYearSchedule;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;

public class YearScheduleConverter
extends DefaultScheduleConverter {
    public YearScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BYearSchedule;
    }

    @Override
    public ICalendar convert(BAbstractSchedule schedule, ICalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("YearScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        BYearSchedule ys = (BYearSchedule)schedule;
        VEvent event = new VEvent();
        ConverterUtils.assignUid((BAbstractSchedule)ys, event);
        PropertyEncoder.encode("X-TRIDIUM-NIAGARA-YEAR", (BValue)BInteger.make((int)(schedule.getAlwaysEffective() ? -1 : ys.getYear())), event);
        event.setSummary(schedule.getDisplayName(null));
        event.setDescription(schedule.getClass().getSimpleName());
        ical.addEvent(event);
        return ical;
    }
}

