/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.ICalendar;
import biweekly.component.VEvent;
import com.tridium.cloudLink.schedule.converter.ControlScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.PropertyEncoder;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BWeekSchedule;
import javax.baja.schedule.BWeeklySchedule;

public class WeeklyScheduleConverter
extends ControlScheduleConverter {
    public WeeklyScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BWeeklySchedule;
    }

    @Override
    public ICalendar convert(BAbstractSchedule schedule, ICalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("WeeklyScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        if (schedule.getEffectiveValue() != null) {
            PropertyEncoder.encode("X-TRIDIUM-NIAGARA-EFFECTIVE-VALUE", schedule.getEffectiveValue().getValueValue(), ical);
        }
        BWeeklySchedule weekly = (BWeeklySchedule)schedule;
        BWeekSchedule week = weekly.getWeek();
        ICalendar weekCal = this.master.convert((BAbstractSchedule)week, new ICalendar());
        for (VEvent e : weekCal.getEvents()) {
            ical.addEvent(e);
        }
        BDailySchedule[] specialEvents = weekly.getSpecialEventsChildren();
        for (int i = 0; i < specialEvents.length; ++i) {
            ICalendar special = this.master.convert((BAbstractSchedule)specialEvents[i], new ICalendar());
            for (VEvent e : special.getEvents()) {
                ical.addEvent(e);
            }
        }
        BDateRangeSchedule effectiveRange = weekly.getEffective();
        ICalendar rangeCal = this.master.convert((BAbstractSchedule)effectiveRange, new ICalendar());
        VEvent start = rangeCal.getEvents().get(0);
        PropertyEncoder.copyProperty(start, "X-TRIDIUM-NIAGARA-YEAR", ical, "X-TRIDIUM-NIAGARA-RANGE-START-YEAR");
        PropertyEncoder.copyProperty(start, "X-TRIDIUM-NIAGARA-MONTH", ical, "X-TRIDIUM-NIAGARA-RANGE-START-MONTH");
        PropertyEncoder.copyProperty(start, "X-TRIDIUM-NIAGARA-DAY", ical, "X-TRIDIUM-NIAGARA-RANGE-START-DAY");
        PropertyEncoder.copyProperty(start, "X-TRIDIUM-NIAGARA-DAY-OF-WEEK", ical, "X-TRIDIUM-NIAGARA-RANGE-START-DAY-OF-WEEK");
        VEvent end = rangeCal.getEvents().get(1);
        PropertyEncoder.copyProperty(end, "X-TRIDIUM-NIAGARA-YEAR", ical, "X-TRIDIUM-NIAGARA-RANGE-END-YEAR");
        PropertyEncoder.copyProperty(end, "X-TRIDIUM-NIAGARA-MONTH", ical, "X-TRIDIUM-NIAGARA-RANGE-END-MONTH");
        PropertyEncoder.copyProperty(end, "X-TRIDIUM-NIAGARA-DAY", ical, "X-TRIDIUM-NIAGARA-RANGE-END-DAY");
        PropertyEncoder.copyProperty(end, "X-TRIDIUM-NIAGARA-DAY-OF-WEEK", ical, "X-TRIDIUM-NIAGARA-RANGE-END-DAY-OF-WEEK");
        ConverterUtils.applyRange(rangeCal, ical);
        ical.getTimezoneInfo().setGlobalFloatingTime(true);
        return ical;
    }
}

