/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.ICalendar;
import biweekly.component.VEvent;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.EnumSetScheduleConverter;
import com.tridium.cloudLink.schedule.converter.PropertyEncoder;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BWeekdaySchedule;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;

public class WeekdayScheduleConverter
extends EnumSetScheduleConverter {
    public WeekdayScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BWeekdaySchedule;
    }

    @Override
    public ICalendar convert(BAbstractSchedule schedule, ICalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("WeekdayScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        BWeekdaySchedule wds = (BWeekdaySchedule)schedule;
        if (!wds.getSet().isNull()) {
            VEvent event = new VEvent();
            ConverterUtils.assignUid((BAbstractSchedule)wds, event);
            PropertyEncoder.encode("X-TRIDIUM-NIAGARA-DAY-OF-WEEK", (BValue)BString.make((String)schedule.get("set").toString()), event);
            event.setSummary(schedule.getDisplayName(null));
            event.setDescription(schedule.getClass().getSimpleName());
            ical.addEvent(event);
        }
        return ical;
    }
}

