/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.ICalendar;
import biweekly.component.VEvent;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import java.io.IOException;
import java.util.List;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BWeekSchedule;

public class WeekScheduleConverter
extends DefaultScheduleConverter {
    public WeekScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BWeekSchedule;
    }

    @Override
    public ICalendar convert(BAbstractSchedule schedule, ICalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("WeekScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        ical.getTimezoneInfo().setGlobalFloatingTime(true);
        BWeekSchedule coreSchedule = (BWeekSchedule)schedule;
        BDailySchedule[] kids = coreSchedule.schedulesInOrder(null);
        for (int i = 0; i < kids.length; ++i) {
            ICalendar ci = this.master.convert((BAbstractSchedule)kids[i], new ICalendar());
            List<VEvent> ei = ci.getEvents();
            for (VEvent e : ei) {
                ical.addEvent(e);
            }
        }
        return ical;
    }
}

