/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.ICalendar;
import biweekly.component.VEvent;
import biweekly.property.RawProperty;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BWeekAndDaySchedule;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;

public class WeekAndDayScheduleConverter
extends DefaultScheduleConverter {
    public WeekAndDayScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BWeekAndDaySchedule;
    }

    @Override
    public ICalendar convert(BAbstractSchedule schedule, ICalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("WeekAndDayScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        VEvent weekAndDayEvent = new VEvent();
        ConverterUtils.assignUid(schedule, weekAndDayEvent);
        BAbstractSchedule[] kids = (BAbstractSchedule[])schedule.getChildren(BAbstractSchedule.class);
        for (int i = 0; i < kids.length; ++i) {
            ICalendar ci = this.master.convert(kids[i], new ICalendar());
            for (VEvent e : ci.getEvents()) {
                for (RawProperty prop : e.getExperimentalProperties()) {
                    weekAndDayEvent.addExperimentalProperty(prop.getName(), prop.getValue());
                }
            }
        }
        weekAndDayEvent.setSummary(schedule.getDisplayName((Context)new BasicContext()));
        weekAndDayEvent.setDescription(schedule.getClass().getSimpleName());
        ical.addEvent(weekAndDayEvent);
        return ical;
    }
}

