/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.ICalendar;
import biweekly.component.VEvent;
import biweekly.property.RecurrenceRule;
import biweekly.util.Frequency;
import biweekly.util.Recurrence;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.PropertyEncoder;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;

public class TimeScheduleConverter
extends DefaultScheduleConverter {
    static final Logger log = Logger.getLogger("cloudLink.channel.schedule");

    public TimeScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BTimeSchedule;
    }

    @Override
    public ICalendar convert(BAbstractSchedule schedule, ICalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("TimeScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        BTimeSchedule timeSchedule = (BTimeSchedule)schedule;
        VEvent event = new VEvent();
        ConverterUtils.assignUid((BAbstractSchedule)timeSchedule, event);
        String scheduleName = schedule.getDisplayName((Context)new BasicContext());
        try {
            ical.getTimezoneInfo().setGlobalFloatingTime(true);
            event.setDateStart(ConverterUtils.localDate(timeSchedule.getStart()), true);
            Date localEnd = ConverterUtils.localDate(timeSchedule.getFinish());
            if (timeSchedule.getFinish().equals((Object)BTime.DEFAULT)) {
                localEnd.setTime(localEnd.getTime() + 86400000L);
            }
            event.setDateEnd(localEnd, true);
            PropertyEncoder.encode("X-TRIDIUM-NIAGARA-ALWAYS-EFFECTIVE", (BValue)BBoolean.make((boolean)schedule.getAlwaysEffective()), event);
            if (timeSchedule.getEffectiveValue() != null) {
                PropertyEncoder.encode("X-TRIDIUM-NIAGARA-EFFECTIVE-VALUE", timeSchedule.getEffectiveValue().getValueValue(), event);
            }
            event.setRecurrenceRule(new RecurrenceRule(new Recurrence.Builder(Frequency.DAILY).build()));
        }
        catch (IOException e) {
            log.log(Level.WARNING, e, () -> "Error converting TimeSchedule to ICalendar");
        }
        event.setSummary(scheduleName);
        ical.addEvent(event);
        return ical;
    }
}

