/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.ICalendar;
import com.tridium.cloudLink.schedule.converter.BooleanScheduleConverter;
import com.tridium.cloudLink.schedule.converter.CalendarScheduleConverter;
import com.tridium.cloudLink.schedule.converter.CompositeScheduleConverter;
import com.tridium.cloudLink.schedule.converter.DailyScheduleConverter;
import com.tridium.cloudLink.schedule.converter.DateRangeScheduleConverter;
import com.tridium.cloudLink.schedule.converter.DateScheduleConverter;
import com.tridium.cloudLink.schedule.converter.DayOfMonthScheduleConverter;
import com.tridium.cloudLink.schedule.converter.DayScheduleConverter;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.EnumScheduleConverter;
import com.tridium.cloudLink.schedule.converter.IScheduleConverter;
import com.tridium.cloudLink.schedule.converter.MonthScheduleConverter;
import com.tridium.cloudLink.schedule.converter.NumericScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleReferenceConverter;
import com.tridium.cloudLink.schedule.converter.StringScheduleConverter;
import com.tridium.cloudLink.schedule.converter.TimeScheduleConverter;
import com.tridium.cloudLink.schedule.converter.WeekAndDayScheduleConverter;
import com.tridium.cloudLink.schedule.converter.WeekOfMonthScheduleConverter;
import com.tridium.cloudLink.schedule.converter.WeekScheduleConverter;
import com.tridium.cloudLink.schedule.converter.WeekdayScheduleConverter;
import com.tridium.cloudLink.schedule.converter.YearScheduleConverter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BDayOfMonthSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BMonthSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.schedule.BStringSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeekAndDaySchedule;
import javax.baja.schedule.BWeekOfMonthSchedule;
import javax.baja.schedule.BWeekSchedule;
import javax.baja.schedule.BWeekdaySchedule;
import javax.baja.schedule.BYearSchedule;

public class ScheduleConverter {
    private final DefaultScheduleConverter DEFAULT = new DefaultScheduleConverter(this);
    private final Map<Class<? extends BAbstractSchedule>, IScheduleConverter> converters = new HashMap<Class<? extends BAbstractSchedule>, IScheduleConverter>();

    public ScheduleConverter() {
        this.converters.put(BBooleanSchedule.class, new BooleanScheduleConverter(this));
        this.converters.put(BCalendarSchedule.class, new CalendarScheduleConverter(this));
        this.converters.put(BCompositeSchedule.class, new CompositeScheduleConverter(this));
        this.converters.put(BDailySchedule.class, new DailyScheduleConverter(this));
        this.converters.put(BDateRangeSchedule.class, new DateRangeScheduleConverter(this));
        this.converters.put(BDateSchedule.class, new DateScheduleConverter(this));
        this.converters.put(BDayOfMonthSchedule.class, new DayOfMonthScheduleConverter(this));
        this.converters.put(BDaySchedule.class, new DayScheduleConverter(this));
        this.converters.put(BEnumSchedule.class, new EnumScheduleConverter(this));
        this.converters.put(BMonthSchedule.class, new MonthScheduleConverter(this));
        this.converters.put(BNumericSchedule.class, new NumericScheduleConverter(this));
        this.converters.put(BScheduleReference.class, new ScheduleReferenceConverter(this));
        this.converters.put(BStringSchedule.class, new StringScheduleConverter(this));
        this.converters.put(BTimeSchedule.class, new TimeScheduleConverter(this));
        this.converters.put(BWeekAndDaySchedule.class, new WeekAndDayScheduleConverter(this));
        this.converters.put(BWeekdaySchedule.class, new WeekdayScheduleConverter(this));
        this.converters.put(BWeekOfMonthSchedule.class, new WeekOfMonthScheduleConverter(this));
        this.converters.put(BWeekSchedule.class, new WeekScheduleConverter(this));
        this.converters.put(BYearSchedule.class, new YearScheduleConverter(this));
    }

    public ICalendar convert(BAbstractSchedule schedule, ICalendar ical) throws IOException {
        return this.converters.getOrDefault(schedule.getClass(), this.DEFAULT).convert(schedule, ical);
    }
}

