/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.ICalendar;
import biweekly.component.VEvent;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.EnumSetScheduleConverter;
import com.tridium.cloudLink.schedule.converter.PropertyEncoder;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BMonthSchedule;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;

public class MonthScheduleConverter
extends EnumSetScheduleConverter {
    public MonthScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BMonthSchedule;
    }

    @Override
    public ICalendar convert(BAbstractSchedule schedule, ICalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("MonthScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        BMonthSchedule ms = (BMonthSchedule)schedule;
        if (!ms.getSet().isNull()) {
            VEvent event = new VEvent();
            ConverterUtils.assignUid((BAbstractSchedule)ms, event);
            PropertyEncoder.encode("X-TRIDIUM-NIAGARA-MONTH", (BValue)BString.make((String)schedule.get("set").toString()), event);
            event.setSummary(schedule.getDisplayName(null));
            event.setDescription(schedule.getClass().getSimpleName());
            ical.addEvent(event);
        }
        return ical;
    }
}

