/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.ICalendar;
import biweekly.property.CalendarScale;
import biweekly.property.Method;
import com.tridium.cloudLink.schedule.converter.IScheduleConverter;
import com.tridium.cloudLink.schedule.converter.PropertyEncoder;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class DefaultScheduleConverter
implements IScheduleConverter {
    protected ScheduleConverter master;

    public DefaultScheduleConverter(ScheduleConverter masterConverter) {
        this.master = masterConverter;
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule != null;
    }

    @Override
    public ICalendar convert(BAbstractSchedule schedule, ICalendar ical) throws IOException {
        if (!this.canConvert(schedule) || ical == null) {
            throw new IllegalArgumentException("Cannot apply default schedule converter");
        }
        ical.setProductId("-//Tridium//NONSGML Niagara Schedules v1.0//EN");
        ical.setExperimentalProperty("X-WR-CALNAME", schedule.getDisplayName((Context)new BasicContext()));
        ical.setCalendarScale(CalendarScale.gregorian());
        ical.setMethod(Method.publish());
        PropertyEncoder.encode("X-TRIDIUM-NIAGARA-ALWAYS-EFFECTIVE", (BValue)BBoolean.make((boolean)schedule.getAlwaysEffective()), ical);
        String typeSpec = BTypeSpec.make((Type)schedule.getType()).encodeToString();
        PropertyEncoder.encode("X-TRIDIUM-NIAGARA-CLASS", (BValue)BString.make((String)typeSpec), ical);
        return ical;
    }
}

