/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.ICalendar;
import biweekly.component.VEvent;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BTimeSchedule;

public class DayScheduleConverter
extends DefaultScheduleConverter {
    public DayScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BDaySchedule;
    }

    @Override
    public ICalendar convert(BAbstractSchedule schedule, ICalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("DayScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        BTimeSchedule[] kids = (BTimeSchedule[])schedule.getChildren(BTimeSchedule.class);
        for (int i = 0; i < kids.length; ++i) {
            ICalendar ci = this.master.convert((BAbstractSchedule)kids[i], new ICalendar());
            for (VEvent e : ci.getEvents()) {
                ical.addEvent(e);
            }
        }
        return ical;
    }
}

