/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.ICalendar;
import biweekly.component.VEvent;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;

public class DateRangeScheduleConverter
extends DefaultScheduleConverter {
    public DateRangeScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BDateRangeSchedule;
    }

    @Override
    public ICalendar convert(BAbstractSchedule schedule, ICalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("DateRangeScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        BDateRangeSchedule range = (BDateRangeSchedule)schedule;
        BDateSchedule start = range.getStart();
        BDateSchedule end = range.getEnd();
        ICalendar calStart = this.master.convert((BAbstractSchedule)start, new ICalendar());
        ICalendar calEnd = this.master.convert((BAbstractSchedule)end, new ICalendar());
        for (VEvent e : calStart.getEvents()) {
            e.setSummary("Range " + (String)e.getSummary().getValue());
            ical.addEvent(e);
        }
        for (VEvent e : calEnd.getEvents()) {
            e.setSummary("Range " + (String)e.getSummary().getValue());
            ical.addEvent(e);
        }
        return ical;
    }
}

