/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.ICalendar;
import biweekly.component.VEvent;
import biweekly.property.RecurrenceRule;
import biweekly.util.ICalDate;
import com.tridium.cloudLink.schedule.converter.ConverterUtils;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.PropertyEncoder;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class DailyScheduleConverter
extends DefaultScheduleConverter {
    static final Logger log = Logger.getLogger("cloudLink.channel.schedule");

    public DailyScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BDailySchedule;
    }

    @Override
    public ICalendar convert(BAbstractSchedule schedule, ICalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("DailyScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        String scheduleName = schedule.getDisplayName((Context)new BasicContext());
        BDailySchedule daily = (BDailySchedule)schedule;
        BDaySchedule day = daily.getDay();
        BAbstractSchedule days = daily.getDays();
        ICalendar rangeCal = this.master.convert(days, new ICalendar());
        ICalendar dayCal = this.master.convert((BAbstractSchedule)day, new ICalendar());
        List<VEvent> dayEvents = dayCal.getEvents();
        String typeSpec = BTypeSpec.make((Type)days.getType()).encodeToString();
        for (VEvent de : dayEvents) {
            VEvent e = new VEvent(de);
            Optional<Date> rangeStartDate = ConverterUtils.extractDate(rangeCal.getEvents().get(0), true);
            rangeStartDate.ifPresent(date -> e.setDateStart(ConverterUtils.combineDates(date, (ICalDate)de.getDateStart().getValue())));
            rangeStartDate.ifPresent(date -> e.setDateEnd(ConverterUtils.combineDates(date, (ICalDate)de.getDateEnd().getValue())));
            ConverterUtils.adjustEndOfDay(e);
            RecurrenceRule recurrenceRule = ConverterUtils.makeRecurrenceRule(rangeCal, schedule.getName());
            if (recurrenceRule == null) {
                throw new UnsupportedOperationException("Unsupported recurrence rule: different start and end year or endDate < startDate with Month as a wildcard : " + schedule.getClass().getName());
            }
            e.setRecurrenceRule(recurrenceRule);
            e.setSummary(scheduleName + " " + (String)de.getSummary().getValue());
            PropertyEncoder.encode("X-TRIDIUM-NIAGARA-PARENT", (BValue)BString.make((String)schedule.getName()), e);
            PropertyEncoder.encode("X-TRIDIUM-NIAGARA-TYPESPEC", (BValue)BString.make((String)typeSpec), e);
            this.addRangeProperties(e, rangeCal, days);
            ical.addEvent(e);
        }
        ConverterUtils.applyRange(rangeCal, ical);
        return ical;
    }

    private void addRangeProperties(VEvent event, ICalendar rangeCal, BAbstractSchedule days) {
        List<VEvent> rangeEvents = rangeCal.getEvents();
        if (days instanceof BDateSchedule) {
            if (rangeEvents.size() == 1) {
                VEvent de = rangeCal.getEvents().get(0);
                PropertyEncoder.copyProperty(de, "X-TRIDIUM-NIAGARA-YEAR", event, null);
                PropertyEncoder.copyProperty(de, "X-TRIDIUM-NIAGARA-MONTH", event, null);
                PropertyEncoder.copyProperty(de, "X-TRIDIUM-NIAGARA-DAY", event, null);
                PropertyEncoder.copyProperty(de, "X-TRIDIUM-NIAGARA-DAY-OF-WEEK", event, null);
            } else {
                log.log(Level.INFO, String.format("Invalid number of events %d for DateSchedule '%s': ", rangeEvents.size(), rangeCal));
            }
        } else if (days instanceof BDateRangeSchedule) {
            if (rangeEvents.size() == 2) {
                VEvent start = rangeCal.getEvents().get(0);
                PropertyEncoder.copyProperty(start, "X-TRIDIUM-NIAGARA-YEAR", event, "X-TRIDIUM-NIAGARA-RANGE-START-YEAR");
                PropertyEncoder.copyProperty(start, "X-TRIDIUM-NIAGARA-MONTH", event, "X-TRIDIUM-NIAGARA-RANGE-START-MONTH");
                PropertyEncoder.copyProperty(start, "X-TRIDIUM-NIAGARA-DAY", event, "X-TRIDIUM-NIAGARA-RANGE-START-DAY");
                PropertyEncoder.copyProperty(start, "X-TRIDIUM-NIAGARA-DAY-OF-WEEK", event, "X-TRIDIUM-NIAGARA-RANGE-START-DAY-OF-WEEK");
                VEvent end = rangeCal.getEvents().get(1);
                PropertyEncoder.copyProperty(end, "X-TRIDIUM-NIAGARA-YEAR", event, "X-TRIDIUM-NIAGARA-RANGE-END-YEAR");
                PropertyEncoder.copyProperty(end, "X-TRIDIUM-NIAGARA-MONTH", event, "X-TRIDIUM-NIAGARA-RANGE-END-MONTH");
                PropertyEncoder.copyProperty(end, "X-TRIDIUM-NIAGARA-DAY", event, "X-TRIDIUM-NIAGARA-RANGE-END-DAY");
                PropertyEncoder.copyProperty(end, "X-TRIDIUM-NIAGARA-DAY-OF-WEEK", event, "X-TRIDIUM-NIAGARA-RANGE-END-DAY-OF-WEEK");
            } else {
                log.log(Level.INFO, String.format("Invalid number of events %d for DateRangeSchedule '%s': ", rangeEvents.size(), rangeCal));
            }
        }
    }
}

