/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.ICalendar;
import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.schedule.converter.DefaultScheduleConverter;
import com.tridium.cloudLink.schedule.converter.PropertyEncoder;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;

public class ControlScheduleConverter
extends DefaultScheduleConverter {
    public ControlScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BControlSchedule;
    }

    @Override
    public ICalendar convert(BAbstractSchedule schedule, ICalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("ControlScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        TagUtil.getCloudId((BComponent)schedule).ifPresent(id -> ical.setUid(id.toString()));
        super.convert(schedule, ical);
        BControlSchedule controlSchedule = (BControlSchedule)schedule;
        BAbsTime lastModified = controlSchedule.getLastModified();
        if (lastModified != BAbsTime.NULL) {
            ical.setLastModified(Date.from(Instant.ofEpochMilli(lastModified.getMillis())));
        }
        PropertyEncoder.encode("X-TRIDIUM-NIAGARA-CLEANUP-EXPIRED-EVENTS", (BValue)BBoolean.make((boolean)controlSchedule.getCleanupExpiredEvents()), ical);
        BStatusValue defaultOutput = controlSchedule.getDefaultOutput();
        if (defaultOutput != null && defaultOutput.getValueValue() != null) {
            PropertyEncoder.encode("X-TRIDIUM-NIAGARA-DEFAULT-OUTPUT", controlSchedule.getDefaultOutput().getValueValue(), ical);
        }
        PropertyEncoder.encode("X-TRIDIUM-NIAGARA-FACETS", (BValue)BString.make((String)controlSchedule.getFacets().encodeToString()), ical);
        PropertyEncoder.encode("X-TRIDIUM-NIAGARA-SCAN-LIMIT", (BValue)controlSchedule.getScanLimit(), ical);
        PropertyEncoder.encode("X-TRIDIUM-NIAGARA-UNION", (BValue)BBoolean.make((boolean)controlSchedule.getUnion()), ical);
        return ical;
    }
}

