/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule.converter;

import biweekly.ICalendar;
import biweekly.component.VEvent;
import com.tridium.cloudLink.schedule.converter.ControlScheduleConverter;
import com.tridium.cloudLink.schedule.converter.ScheduleConverter;
import java.io.IOException;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;

public class CalendarScheduleConverter
extends ControlScheduleConverter {
    public CalendarScheduleConverter(ScheduleConverter masterConverter) {
        super(masterConverter);
    }

    @Override
    public boolean canConvert(BAbstractSchedule schedule) {
        return schedule instanceof BCalendarSchedule;
    }

    @Override
    public ICalendar convert(BAbstractSchedule schedule, ICalendar ical) throws IOException {
        if (!this.canConvert(schedule)) {
            throw new IllegalArgumentException("CalendarScheduleConverter invoked on schedule of type " + schedule.getClass().getName());
        }
        super.convert(schedule, ical);
        BCalendarSchedule calendarSchedule = (BCalendarSchedule)schedule;
        BAbstractSchedule[] schedules = calendarSchedule.getSchedules();
        for (int i = 0; i < schedules.length; ++i) {
            ICalendar ci = this.master.convert(schedules[i], new ICalendar());
            for (VEvent e : ci.getEvents()) {
                e.setSummary(schedule.getDisplayName((Context)new BasicContext()));
                ical.addEvent(e);
            }
        }
        return ical;
    }
}

