/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule;

import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.channel.BScheduleChannel;
import com.tridium.cloudLink.schedule.BCloudScheduleExportPolicy;
import com.tridium.cloudLink.schedule.BCloudScheduleImportPolicy;
import com.tridium.cloudLink.schedule.BCloudSchedulePolicy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BControlSchedule;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperty(name="maxConcurrentExecutions", type="int", defaultValue="10", facets={@Facet(name="BFacets.MIN", value="MIN_THREAD_POOL_SIZE")})
@NiagaraActions(value={@NiagaraAction(name="createExportPolicies"), @NiagaraAction(name="executeAll", flags=256), @NiagaraAction(name="retryFailedPolicies", flags=256)})
public class BCloudSchedulePolicyContainer
extends BComponent {
    private static final int MIN_THREAD_POOL_SIZE = 1;
    public static final Property maxConcurrentExecutions = BCloudSchedulePolicyContainer.newProperty((int)0, (int)10, (BFacets)BFacets.make((String)"min", (int)1));
    public static final Action createExportPolicies = BCloudSchedulePolicyContainer.newAction((int)0, null);
    public static final Action executeAll = BCloudSchedulePolicyContainer.newAction((int)256, null);
    public static final Action retryFailedPolicies = BCloudSchedulePolicyContainer.newAction((int)256, null);
    public static final Type TYPE = Sys.loadType(BCloudSchedulePolicyContainer.class);
    static final Logger log = Logger.getLogger("cloudLink.channel.schedule");
    private static final int DEFAULT_QUEUE_SIZE = 500;
    private static final int QUEUE_SIZE;
    private static final String FIND_ALL_SCHEDULES_ORD_STR = "station:|slot:/|bql:select ordInSession from schedule:ControlSchedule";
    Queue asyncWorkQueue;
    private ThreadPoolWorker worker;

    public int getMaxConcurrentExecutions() {
        return this.getInt(maxConcurrentExecutions);
    }

    public void setMaxConcurrentExecutions(int v) {
        this.setInt(maxConcurrentExecutions, v, null);
    }

    public void createExportPolicies() {
        this.invoke(createExportPolicies, null, null);
    }

    public void executeAll() {
        this.invoke(executeAll, null, null);
    }

    public void retryFailedPolicies() {
        this.invoke(retryFailedPolicies, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BScheduleChannel;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BCloudScheduleExportPolicy || child instanceof BCloudScheduleImportPolicy;
    }

    public void started() throws Exception {
        super.started();
        int maxPoolSize = this.getMaxConcurrentExecutions();
        if (maxPoolSize < 1) {
            maxPoolSize = 1;
        }
        if (this.asyncWorkQueue == null) {
            this.asyncWorkQueue = new CoalesceQueue(QUEUE_SIZE);
        }
        if (this.worker == null) {
            this.worker = new ThreadPoolWorker((Worker.ITodo)this.asyncWorkQueue);
        }
        if (!this.worker.isRunning()) {
            this.worker.setMaxThreads(maxPoolSize);
            this.worker.start("CloudScheduleWorker");
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        Property retryLink = this.getProperty("retryLink");
        if (retryLink != null) {
            this.remove(retryLink);
        }
        if (this.worker != null && this.worker.isRunning()) {
            try {
                this.worker.stop();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e, () -> "Unable to stop the Cloud Schedule Export ThreadPoolWorker");
            }
        }
    }

    public void changed(Property property, Context cx) {
        if (this.isRunning() && maxConcurrentExecutions.equals(property) && this.worker != null) {
            int maxPoolSize = this.getMaxConcurrentExecutions();
            if (maxPoolSize < 1) {
                maxPoolSize = 1;
            }
            this.worker.setMaxThreads(maxPoolSize);
        }
        super.changed(property, cx);
    }

    public void doCreateExportPolicies() {
        int createdCnt;
        int dupImportCnt;
        int dupExportCnt;
        int noCloudIdCnt;
        int schedulesCnt;
        block20: {
            if (!this.isRunning()) {
                return;
            }
            log.info("Generating Cloud Schedule Export Policies for all valid Schedules");
            Map<BControlSchedule, BCloudSchedulePolicy> schedulePolicyMap = this.getPoliciesBySchedule();
            BITable foundSchedules = (BITable)BOrd.make((String)FIND_ALL_SCHEDULES_ORD_STR).get();
            schedulesCnt = 0;
            noCloudIdCnt = 0;
            dupExportCnt = 0;
            dupImportCnt = 0;
            createdCnt = 0;
            TableCursor cursor = foundSchedules.cursor();
            Throwable throwable = null;
            block11: while (true) {
                try {
                    while (cursor.next()) {
                        Object scheduleRow = cursor.get();
                        if (!(scheduleRow instanceof BControlSchedule)) continue;
                        BControlSchedule schedule = (BControlSchedule)scheduleRow;
                        log.fine(() -> String.format("Found schedule %s: checking for exportability", schedule.getSlotPath()));
                        ++schedulesCnt;
                        if (!TagUtil.getCloudIdString((BIObject)schedule).isPresent()) {
                            log.fine(() -> String.format("Skipping export policy creation for %s: No cloudId for schedule", schedule.getSlotPath()));
                            ++noCloudIdCnt;
                            continue;
                        }
                        BCloudSchedulePolicy existingPolicy = schedulePolicyMap.get(schedule);
                        if (existingPolicy instanceof BCloudScheduleExportPolicy) {
                            log.fine(() -> String.format("Skipping export policy creation for %s: Export policy already exists", schedule.getSlotPath()));
                            ++dupExportCnt;
                            continue;
                        }
                        if (existingPolicy instanceof BCloudScheduleImportPolicy) {
                            log.fine(() -> String.format("Skipping import policy creation for %s: Import policy already exists", schedule.getSlotPath()));
                            ++dupImportCnt;
                            continue;
                        }
                        log.finest("Creating export policy for schedule " + schedule.getName());
                        BCloudScheduleExportPolicy policy = new BCloudScheduleExportPolicy();
                        try {
                            policy.setScheduleReference(schedule.getNavOrd().relativizeToSession());
                            this.add(schedule.getName() + '?', (BValue)policy);
                            log.info(() -> String.format("Added cloud export policy %s for schedule %s", policy.getName(), schedule.getSlotPath()));
                            ++createdCnt;
                            continue block11;
                        }
                        catch (BajaRuntimeException unexpected) {
                            log.log(Level.INFO, String.format("Unable to create cloud export policy %s for schedule %s: %s", policy.getName(), schedule.getSlotPath(), unexpected.getMessage()), log.isLoggable(Level.FINE) ? unexpected : null);
                        }
                    }
                    break block20;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        log.info(String.format("Finished automatic schedule export policy generation: schedules found=%s, exports created=%s, skipped(no cloud id)=%s, skipped(duplicate export)=%s, skipped(duplicate import)=%s", schedulesCnt, noCloudIdCnt, dupExportCnt, dupImportCnt, createdCnt));
    }

    public void doExecuteAll() {
        BCloudScheduleImportPolicy[] importPolicies;
        BCloudScheduleExportPolicy[] exportPolicies;
        if (!this.isRunning()) {
            return;
        }
        for (BCloudScheduleExportPolicy exportPolicy : exportPolicies = (BCloudScheduleExportPolicy[])this.getChildren(BCloudScheduleExportPolicy.class)) {
            if (!exportPolicy.getEnabled()) continue;
            exportPolicy.execute();
        }
        for (BCloudScheduleImportPolicy importPolicy : importPolicies = (BCloudScheduleImportPolicy[])this.getChildren(BCloudScheduleImportPolicy.class)) {
            if (!importPolicy.getEnabled()) continue;
            importPolicy.execute();
        }
    }

    public void doRetryFailedPolicies() {
        BCloudScheduleImportPolicy[] importPolicies;
        BCloudScheduleExportPolicy[] exportPolicies;
        if (!this.isRunning()) {
            return;
        }
        for (BCloudScheduleExportPolicy config : exportPolicies = (BCloudScheduleExportPolicy[])this.getChildren(BCloudScheduleExportPolicy.class)) {
            if (config.isUnoperational() || !config.isFault()) continue;
            config.execute();
        }
        for (BCloudScheduleImportPolicy config : importPolicies = (BCloudScheduleImportPolicy[])this.getChildren(BCloudScheduleImportPolicy.class)) {
            if (config.isUnoperational() || !config.isFault()) continue;
            config.execute();
        }
    }

    public final BScheduleChannel getChannel() {
        return (BScheduleChannel)this.getParent();
    }

    public final Map<BControlSchedule, BCloudSchedulePolicy> getPoliciesBySchedule() {
        HashMap<BControlSchedule, BCloudSchedulePolicy> map = new HashMap<BControlSchedule, BCloudSchedulePolicy>();
        Arrays.stream(this.getChildren(BCloudSchedulePolicy.class)).forEach(policy -> {
            BControlSchedule schedule = policy.validateScheduleReference();
            if (schedule != null) {
                map.put(schedule, (BCloudSchedulePolicy)((Object)policy));
            }
        });
        return map;
    }

    public final Map<String, BCloudSchedulePolicy> getPoliciesByCloudId() {
        HashMap<String, BCloudSchedulePolicy> map = new HashMap<String, BCloudSchedulePolicy>();
        Arrays.stream(this.getChildren(BCloudSchedulePolicy.class)).forEach(policy -> {
            BControlSchedule schedule = policy.validateScheduleReference();
            if (schedule != null) {
                Optional scheduleCloudId = TagUtil.getCloudIdString((BIObject)schedule);
                scheduleCloudId.ifPresent(s -> map.put((String)s, (BCloudSchedulePolicy)((Object)policy)));
            }
        });
        return map;
    }

    public final Map<String, BControlSchedule> getSchedulesByCloudId() {
        HashMap<String, BControlSchedule> map = new HashMap<String, BControlSchedule>();
        BITable foundSchedules = (BITable)BOrd.make((String)FIND_ALL_SCHEDULES_ORD_STR).get();
        try (TableCursor cursor = foundSchedules.cursor();){
            while (cursor.next()) {
                Object o = cursor.get();
                if (!(o instanceof BControlSchedule)) continue;
                BControlSchedule cs = (BControlSchedule)o;
                Optional optCloudId = TagUtil.getCloudIdString((BIObject)cs);
                optCloudId.ifPresent(s -> map.put((String)s, cs));
            }
        }
        return map;
    }

    BCloudScheduleImportPolicy exportToImport(BCloudScheduleExportPolicy policy) {
        Optional optCloudId = TagUtil.getCloudIdString((BIObject)policy);
        BCloudScheduleImportPolicy importPolicy = new BCloudScheduleImportPolicy();
        importPolicy.setScheduleReference(policy.getScheduleReference());
        String policyName = policy.getName();
        int flags = this.getFlags((Slot)this.getProperty(policyName));
        this.remove(policyName);
        this.add(policyName, (BValue)importPolicy, flags, BFacets.DEFAULT, null);
        optCloudId.ifPresent(id -> TagUtil.getOrAddCloudId((BIEntity)importPolicy, e -> id));
        log.info(() -> String.format("Schedule policy %s for schedule %s switched from export to import", importPolicy.getSlotPath(), importPolicy.getScheduleReference()));
        return importPolicy;
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning() && this.worker != null) {
            this.worker.spy(out);
        }
        super.spy(out);
    }

    static {
        int size = Integer.getInteger("cloudLink.schedule.workerQueueSize", 500);
        if (size < 1) {
            size = 500;
        }
        QUEUE_SIZE = size;
    }
}

