/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.schedule;

import biweekly.Biweekly;
import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.ValidationWarnings;
import biweekly.io.ParseWarning;
import biweekly.io.chain.ChainingTextStringParser;
import com.tridium.cloudLink.channel.BScheduleChannel;
import com.tridium.cloudLink.schedule.BCloudSchedulePolicy;
import com.tridium.cloudLink.schedule.CloudScheduleImportResult;
import com.tridium.cloudLink.schedule.reverter.WeeklyScheduleReverter;
import com.tridium.cloudLink.util.BCompletableFutureWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.sync.Transaction;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BManualTriggerMode.make())", override=true), @NiagaraProperty(name="supervisorVersion", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=9)})
@NiagaraAction(name="importSchedule", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BCompletableFutureWrapper", flags=4, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")})
public class BCloudScheduleImportPolicy
extends BCloudSchedulePolicy
implements BIAlarmSource,
IPropertyValidator {
    public static final Property executionTime = BCloudScheduleImportPolicy.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BManualTriggerMode.make()), null);
    public static final Property supervisorVersion = BCloudScheduleImportPolicy.newProperty((int)9, (BValue)BAbsTime.NULL, null);
    public static final Action importSchedule = BCloudScheduleImportPolicy.newAction((int)4, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE = Sys.loadType(BCloudScheduleImportPolicy.class);
    private final WeeklyScheduleReverter reverter = new WeeklyScheduleReverter();

    public BAbsTime getSupervisorVersion() {
        return (BAbsTime)this.get(supervisorVersion);
    }

    public void setSupervisorVersion(BAbsTime v) {
        this.set(supervisorVersion, (BValue)v, null);
    }

    public BCompletableFutureWrapper importSchedule(BString parameter) {
        return (BCompletableFutureWrapper)this.invoke(importSchedule, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property.equals(scheduleReference)) {
            this.validateScheduleReference();
            this.setSupervisorVersion(BAbsTime.NULL);
            log.info(() -> String.format("The schedule import policy %s reference has changed, clearing supervisor version property", this.getDisplayName(null)));
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(importSchedule)) {
            if (this.isUnoperational()) {
                return null;
            }
            if (this.getState() != BDescriptorState.idle) {
                return null;
            }
            this.setLastAttempt(Clock.time());
            this.setState(BDescriptorState.pending);
            return this.postExecute(action, arg, cx);
        }
        return super.post(action, arg, cx);
    }

    public void doExecute() {
        if (!this.isRunning()) {
            return;
        }
        this.executeInProgress();
        try {
            BScheduleChannel channel = this.getChannel();
            if (channel == null) {
                this.executeFail(lex.getText("schedule.policy.channel.notFound"));
                return;
            }
            BControlSchedule schedule = this.validateScheduleReference();
            if (schedule == null) {
                log.log(Level.INFO, String.format("Schedule import policy %s failed due to schedule reference validation error", this.getDisplayName(null)));
                this.executeFail(this.getFaultCause());
                return;
            }
            BAbsTime modificationTime = (BAbsTime)schedule.get("lastModified");
            if (!this.getSupervisorVersion().isAfter(modificationTime)) {
                log.fine(() -> String.format("Schedule import policy %s, target schedule %s is already up to date", this.getDisplayName(null), this.getScheduleReference().encodeToString()));
                this.executeOk();
                return;
            }
            this.setSupervisorVersion(modificationTime);
            this.executeOk();
        }
        catch (Exception ex) {
            log.log(Level.INFO, String.format("Schedule import policy %s, unable to export target schedule %s", this.getDisplayName(null), ex.getMessage()), log.isLoggable(Level.FINE) ? ex : null);
            this.executeFail(ex);
        }
    }

    public BCompletableFutureWrapper doImportSchedule(BString icsString) {
        if (!this.isRunning()) {
            return this.wrappedFailure("Schedule import policy is not running.");
        }
        if (this.validateScheduleReference() == null) {
            return this.wrappedFailure(this.getFaultCause());
        }
        try {
            CloudScheduleImportResult result = new CloudScheduleImportResult();
            this.executeInProgress();
            log.fine("Importing schedule data from ICS string:\n" + icsString);
            ArrayList<List<ParseWarning>> parseWarnings = new ArrayList<List<ParseWarning>>();
            ICalendar iCal = ((ChainingTextStringParser)Biweekly.parse(icsString.getString()).warnings(parseWarnings)).first();
            List<String> flattenedParseWarnings = this.collectWarnings(parseWarnings);
            if (iCal == null || !flattenedParseWarnings.isEmpty()) {
                this.executeFail(lex.getText("schedule.policy.import.validation.failure") + ": " + flattenedParseWarnings);
                result.setStatus("Fail");
                result.addMessage("The request does not contain valid iCalendar format.");
                result.addAll(flattenedParseWarnings);
                log.log(Level.FINE, "Schedule import parse warnings: " + flattenedParseWarnings);
                return BCompletableFutureWrapper.make(CompletableFuture.completedFuture(result));
            }
            BAbstractSchedule importedSchedule = this.reverter.revert(iCal);
            ValidationWarnings validationWarnings = iCal.validate(ICalVersion.V2_0);
            List<String> flattenedValidationWarnings = this.collectWarnings(validationWarnings);
            if (!flattenedValidationWarnings.isEmpty()) {
                this.executeFail(lex.getText("schedule.policy.import.validation.failure") + ": " + flattenedValidationWarnings);
                result.setStatus("Fail");
                result.addAll(flattenedValidationWarnings);
                log.log(Level.FINE, "Schedule import validation warnings: " + flattenedValidationWarnings);
            } else {
                BAbstractSchedule existingSchedule = this.getSchedule();
                if (!importedSchedule.getType().is(this.getSchedule().getType())) {
                    this.executeFail(lex.getText("schedule.policy.import.wrong.type"));
                    return this.wrappedFailure(String.format("Wrong schedule type received for schedule update. New schedule type found - %s, current schedule type - %s", importedSchedule.getType(), this.getSchedule().getType()));
                }
                this.deconflictCommonDynamicProperties(existingSchedule, importedSchedule, (Context)new BasicContext());
                existingSchedule.copyFrom(importedSchedule, (Context)new BasicContext());
                this.executeOk();
                this.setSupervisorVersion(BAbsTime.now());
                result = CloudScheduleImportResult.SUCCESS;
            }
            return BCompletableFutureWrapper.make(CompletableFuture.completedFuture(result));
        }
        catch (Exception ex) {
            log.log(Level.WARNING, String.format("Failed to import iCalendar schedule: %s", ex.getMessage()), log.isLoggable(Level.FINE) ? ex : null);
            this.executeFail(ex);
            return BCompletableFutureWrapper.make(CompletableFuture.completedFuture(new CloudScheduleImportResult("Exception", ex.getMessage())));
        }
    }

    private List<String> deconflictCommonDynamicProperties(BAbstractSchedule existingSchedule, BAbstractSchedule importedSchedule, Context cx) {
        ArrayList<String> conflicting = new ArrayList<String>();
        Context txn = Transaction.start((BComponent)existingSchedule, (Context)cx);
        SlotCursor c = importedSchedule.getProperties();
        while (c.next()) {
            Property importedProp = c.property();
            String propName = importedProp.getName();
            Property existingProp = existingSchedule.getProperty(propName);
            if (existingProp == null || !existingProp.isDynamic()) continue;
            existingSchedule.remove(propName, cx);
            conflicting.add(propName);
        }
        try {
            Transaction.end((BComponent)existingSchedule, (Context)txn);
            return conflicting;
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
    }

    private BCompletableFutureWrapper wrappedFailure(String message) {
        return BCompletableFutureWrapper.make(CompletableFuture.completedFuture(new CloudScheduleImportResult("Fail", message)));
    }

    private List<String> collectWarnings(List<List<ParseWarning>> parseWarnings) {
        ArrayList<String> messages = new ArrayList<String>();
        for (List<ParseWarning> group : parseWarnings) {
            for (ParseWarning warning : group) {
                messages.add(warning.toString());
            }
        }
        return messages;
    }

    private List<String> collectWarnings(ValidationWarnings validationWarnings) {
        ArrayList<String> messages = new ArrayList<String>();
        for (ValidationWarnings.WarningsGroup group : validationWarnings.getWarnings()) {
            messages.add(group.toString());
        }
        return messages;
    }
}

