/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.queue;

import com.tridium.cloudLink.channel.BTransportConfig;
import com.tridium.cloudLink.command.BCommandStatus;
import com.tridium.cloudLink.command.CommandRequest;
import com.tridium.cloudLink.queue.BAbstractCommandQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="maxSize", type="BInteger", defaultValue="BInteger.make(20)", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="1024")})
public class BInMemoryCommandQueue
extends BAbstractCommandQueue {
    public static final Property maxSize = BInMemoryCommandQueue.newProperty((int)0, (int)((BInteger)BInteger.make((int)20).as(BInteger.class)).getInt(), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)1024)));
    public static final Type TYPE = Sys.loadType(BInMemoryCommandQueue.class);
    private final ConcurrentLinkedDeque<CommandRequest> queue = new ConcurrentLinkedDeque();
    private static final String IN_MEM = "In-Mem-CmdQ";
    private static final String COLON = ":";

    public int getMaxSize() {
        return this.getInt(maxSize);
    }

    public void setMaxSize(int v) {
        this.setInt(maxSize, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean enqueue(CommandRequest request) {
        if (this.queue.size() < this.getMaxSize()) {
            this.queue.add(request);
            return true;
        }
        return false;
    }

    @Override
    public CommandRequest dequeue() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.pollFirst();
    }

    @Override
    public boolean dequeue(CommandRequest request) {
        return this.queue.remove(request);
    }

    @Override
    public CommandRequest getNextToExecute() {
        for (CommandRequest req : this.queue) {
            if (req.getStatus() != BCommandStatus.Enqueued) continue;
            return req;
        }
        return null;
    }

    @Override
    public int getQueueSize() {
        return this.queue.size();
    }

    public String toString(Context cx) {
        try {
            if (this.isMounted()) {
                return this.getParent().getParent().getParent().getName() + COLON + ((BTransportConfig)this.getParent()).getTransportType() + COLON + IN_MEM;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return IN_MEM;
    }
}

