/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.model;

import com.tridium.cloudLink.channel.BModelChannel;
import com.tridium.cloudLink.model.BModelExportPolicy;
import com.tridium.cloudLink.objectIdentity.BCloudIdManager;
import com.tridium.cloudLink.objectIdentity.BComponentIdentityWorker;
import com.tridium.cloudLink.tag.CloudLinkTagUtil;
import com.tridium.util.CompUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnknownSchemeException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BQueryResult;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Cursor;
import javax.baja.sys.CursorException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.tag.Entity;
import javax.baja.tag.Relation;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="scope", type="BOrd", defaultValue="BOrd.make(\"station:|slot:/\")", flags=5), @NiagaraProperty(name="componentTypes", type="BVector", defaultValue="new BVector()", flags=5), @NiagaraProperty(name="excludedComponentTypes", type="BVector", defaultValue="new BVector()", flags=5)})
public class BComponentExportPolicy
extends BModelExportPolicy {
    public static final Property scope = BComponentExportPolicy.newProperty((int)5, (BValue)BOrd.make((String)"station:|slot:/"), null);
    public static final Property componentTypes = BComponentExportPolicy.newProperty((int)5, (BValue)new BVector(), null);
    public static final Property excludedComponentTypes = BComponentExportPolicy.newProperty((int)5, (BValue)new BVector(), null);
    public static final Type TYPE = Sys.loadType(BComponentExportPolicy.class);
    private static final Logger log = Logger.getLogger("cloudLink.model.exportPolicy");
    protected Cursor<BIEntity> cursor;
    protected boolean cursorDone;
    Iterator<BIHistory> historyIterator;
    protected int numExcluded;
    protected int numIncluded;
    protected boolean hasNext;
    protected BComponent next;
    protected Predicate<BComponent> componentTypeIncludedInModel;
    protected Predicate<Relation> relationTypeIncludeInModel;

    public BOrd getScope() {
        return (BOrd)this.get(scope);
    }

    public void setScope(BOrd v) {
        this.set(scope, (BValue)v, null);
    }

    public BVector getComponentTypes() {
        return (BVector)this.get(componentTypes);
    }

    public void setComponentTypes(BVector v) {
        this.set(componentTypes, (BValue)v, null);
    }

    public BVector getExcludedComponentTypes() {
        return (BVector)this.get(excludedComponentTypes);
    }

    public void setExcludedComponentTypes(BVector v) {
        this.set(excludedComponentTypes, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        BModelChannel channel = this.getChannel();
        if (channel != null) {
            channel.getConnectionService().ifPresent(ccs -> this.linkTo((BComponent)ccs.getCloudIdManager(), (Slot)BCloudIdManager.newCloudIdsAssigned, (Slot)BAbstractDescriptor.execute));
        }
    }

    @Override
    protected void initialize() {
        BOrd queryOrd = BOrd.make((String)"neql:nc:cloudId and not nc:excluded");
        BQueryResult result = (BQueryResult)queryOrd.get(this.getScope().get((BObject)Sys.getStation()));
        this.cursor = result.cursor();
        this.cursorDone = false;
        BHistoryDatabase histDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
        this.historyIterator = Arrays.stream(histDb.getHistories()).iterator();
        this.componentTypeIncludedInModel = this.makeComponentPredicate();
        this.relationTypeIncludeInModel = this.makeRelationPredicate(this.componentTypeIncludedInModel);
    }

    @Override
    protected void cleanup() {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
        this.hasNext = false;
        this.componentTypeIncludedInModel = null;
        this.relationTypeIncludeInModel = null;
    }

    @Override
    public boolean hasNext() {
        this.hasNext = false;
        if (!this.cursorDone) {
            try {
                while (this.cursor.next()) {
                    BIEntity nextEntity = (BIEntity)this.cursor.get();
                    if (!(nextEntity instanceof BComponent)) {
                        ++this.numExcluded;
                        log.finest(() -> "Excluding (not a component) --> " + nextEntity.getType().toString());
                        continue;
                    }
                    BComponent nextComponent = (BComponent)nextEntity;
                    if (!this.componentTypeIncludedInModel.test(nextComponent)) {
                        ++this.numExcluded;
                        log.finest(() -> "Excluding --> " + nextComponent.toDebugString());
                        continue;
                    }
                    ++this.numIncluded;
                    this.hasNext = true;
                    this.next = nextComponent;
                    log.finest(() -> "Including --> " + this.next.toDebugString());
                    break;
                }
                if (!this.hasNext) {
                    this.cursorDone = true;
                    this.hasNextHistory();
                }
            }
            catch (CursorException e) {
                this.hasNext = false;
                this.cursorDone = true;
                this.hasNextHistory();
            }
        } else {
            this.hasNextHistory();
        }
        return this.hasNext;
    }

    private void hasNextHistory() {
        while (this.historyIterator.hasNext()) {
            BIHistory nextHistory = this.historyIterator.next();
            BOrdList ordList = nextHistory.getConfig().getSource();
            if (!ordList.isNull()) {
                BOrd source = ordList.get(ordList.size() - 1);
                try {
                    BComponent sourceComponent;
                    BObject sourceObj = source.get();
                    if (sourceObj instanceof BComponent && BComponentIdentityWorker.sourceMatch(sourceObj, nextHistory.getId()) && (!this.componentTypeIncludedInModel.test(sourceComponent = (BComponent)sourceObj) || CloudLinkTagUtil.entityExcludedFromModel.test((Entity)sourceComponent))) {
                        ++this.numExcluded;
                        log.finest(() -> "Excluding history --> " + nextHistory.getId());
                        continue;
                    }
                }
                catch (InvalidOrdBaseException | NullOrdException | SyntaxException | UnknownSchemeException | UnresolvedException throwable) {
                    // empty catch block
                }
            }
            this.hasNext = true;
            this.next = nextHistory.getConfig();
            break;
        }
    }

    @Override
    public BComponent next() {
        if (!this.hasNext) {
            throw new NoSuchElementException("No more elements are available or you did not first call hasNext().");
        }
        return this.next;
    }

    protected Predicate<BComponent> makeComponentPredicate() {
        BVector includedTypesVector = this.getComponentTypes();
        BVector excludedTypesVector = this.getExcludedComponentTypes();
        if (includedTypesVector.getSlotCount() == 0 && excludedTypesVector.getSlotCount() == 0) {
            return c -> true;
        }
        List includedComponentTypes = Arrays.stream(CompUtil.getDescendants((BComponent)includedTypesVector, BTypeSpec.class)).map(typeSpec -> typeSpec.getResolvedType()).collect(Collectors.toList());
        List excludedComponentTypes = Arrays.stream(CompUtil.getDescendants((BComponent)excludedTypesVector, BTypeSpec.class)).map(typeSpec -> typeSpec.getResolvedType()).collect(Collectors.toList());
        return component -> {
            Type componentType = component.getType();
            return includedComponentTypes.stream().anyMatch(includedType -> componentType.is(includedType)) && excludedComponentTypes.stream().noneMatch(excludedType -> componentType.is(excludedType));
        };
    }

    protected Predicate<Relation> makeRelationPredicate(Predicate<BComponent> componentTypeIncludedInModel) {
        return r -> {
            Entity entity = r.getEndpoint();
            if (entity instanceof BComponent) {
                return componentTypeIncludedInModel.test(((BComponent)entity).asComponent());
            }
            return false;
        };
    }

    @Override
    public Predicate<BComponent> getComponentTypeIncludedInModel() {
        return this.componentTypeIncludedInModel;
    }

    @Override
    public Predicate<Relation> getRelationTypeIncludeInModel() {
        return this.relationTypeIncludeInModel;
    }
}

