/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.history;

import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraEnum(range={@Range(value="identifying", ordinal=2), @Range(value="checkingBackfill", ordinal=3), @Range(value="backfilling", ordinal=4), @Range(value="backfillingIdentifying", ordinal=5), @Range(value="backfillingNeedsCheck", ordinal=6), @Range(value="normal", ordinal=7)}, defaultValue="normal")
public final class BHistoryChannelState
extends BFrozenEnum {
    public static final int IDENTIFYING = 2;
    public static final int CHECKING_BACKFILL = 3;
    public static final int BACKFILLING = 4;
    public static final int BACKFILLING_IDENTIFYING = 5;
    public static final int BACKFILLING_NEEDS_CHECK = 6;
    public static final int NORMAL = 7;
    public static final BHistoryChannelState identifying = new BHistoryChannelState(2);
    public static final BHistoryChannelState checkingBackfill = new BHistoryChannelState(3);
    public static final BHistoryChannelState backfilling = new BHistoryChannelState(4);
    public static final BHistoryChannelState backfillingIdentifying = new BHistoryChannelState(5);
    public static final BHistoryChannelState backfillingNeedsCheck = new BHistoryChannelState(6);
    public static final BHistoryChannelState normal;
    public static final BHistoryChannelState DEFAULT;
    public static final Type TYPE;
    static final Lexicon lex;

    public static BHistoryChannelState make(int ordinal) {
        return (BHistoryChannelState)identifying.getRange().get(ordinal, false);
    }

    public static BHistoryChannelState make(String tag) {
        return (BHistoryChannelState)identifying.getRange().get(tag);
    }

    private BHistoryChannelState(int ordinal) {
        super(ordinal);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDisplayTag(Context cx) {
        switch (this.getOrdinal()) {
            case 2: {
                return lex.get("history.state.identifying");
            }
            case 3: {
                return lex.get("history.state.checkingBackfill");
            }
            case 4: 
            case 5: 
            case 6: {
                return lex.get("history.state.backfilling");
            }
        }
        return lex.get("history.state.normal");
    }

    static {
        DEFAULT = normal = new BHistoryChannelState(7);
        TYPE = Sys.loadType(BHistoryChannelState.class);
        lex = Lexicon.make(BHistoryChannelState.class);
    }
}

