/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.history;

import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.history.BCloudHistoryExportConfig;
import com.tridium.cloudLink.history.BCloudHistoryExportConfigContainer;
import com.tridium.history.audit.BAbstractAuditHistorySource;
import com.tridium.history.log.BLogHistoryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.baja.collection.TableCursor;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BQueryResult;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.BIRestrictedComponent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="false", override=true), @NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeMinutes(15), BDaysOfWeekBits.ALL))", override=true), @NiagaraProperty(name="excludedHistoryIds", type="BVector", defaultValue="new BVector()", flags=5), @NiagaraProperty(name="historyIds", type="BVector", defaultValue="new BVector()", flags=5, override=true)})
public class BCloudHistoryAutoExportConfig
extends BCloudHistoryExportConfig
implements BIRestrictedComponent {
    public static final Property enabled = BCloudHistoryAutoExportConfig.newProperty((int)0, (boolean)false, null);
    public static final Property executionTime = BCloudHistoryAutoExportConfig.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)15), (BDaysOfWeekBits)BDaysOfWeekBits.ALL)), null);
    public static final Property excludedHistoryIds = BCloudHistoryAutoExportConfig.newProperty((int)5, (BValue)new BVector(), null);
    public static final Property historyIds = BCloudHistoryAutoExportConfig.newProperty((int)5, (BValue)new BVector(), null);
    public static final Type TYPE = Sys.loadType(BCloudHistoryAutoExportConfig.class);
    public static final int NO_EXCLUSIONS = 0;
    public static final int EXCLUDED_BY_TAG = 1;
    public static final int EXCLUDED_BY_MANAGER = 2;
    public static final int EXCLUDED_NO_CLOUDID = 4;

    public BVector getExcludedHistoryIds() {
        return (BVector)this.get(excludedHistoryIds);
    }

    public void setExcludedHistoryIds(BVector v) {
        this.set(excludedHistoryIds, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public Set<BHistoryId> getHistoryIdSet() {
        BCloudHistoryExportConfig[] configs;
        BHistoryService historyService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase historyDb = historyService.getDatabase();
        if (historyDb == null) {
            return Collections.emptySet();
        }
        BIHistory[] allHistories = historyDb.getHistories();
        HashSet<BHistoryId> allHistoryIds = new HashSet<BHistoryId>(allHistories.length);
        for (BIHistory history : allHistories) {
            allHistoryIds.add(history.getId());
        }
        Arrays.asList(this.getExcludedHistoryIds().getPropertiesArray()).forEach(property -> {
            try {
                BValue value = this.getExcludedHistoryIds().get(property);
                if (value instanceof BInteger) {
                    int exclusionReason = ((BInteger)value).getInt();
                    if (!BCloudHistoryAutoExportConfig.isExcludedOnlyForReason(exclusionReason, 4)) {
                        allHistoryIds.remove(BHistoryId.make((String)SlotPath.unescape((String)property.getName())));
                    }
                } else if (value instanceof BHistoryId) {
                    BHistoryId historyId = (BHistoryId)value;
                    this.getExcludedHistoryIds().set(property, (BValue)BInteger.make((int)2));
                    this.getExcludedHistoryIds().rename(property, SlotPath.escape((String)historyId.encodeToString()));
                    allHistoryIds.remove(historyId);
                } else {
                    log.config(() -> "Unable to process excluded history id " + property.getName());
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Unable to process excluded history id " + property.getName(), log.isLoggable(Level.FINE) ? e : null);
            }
        });
        BCloudHistoryExportConfigContainer container = (BCloudHistoryExportConfigContainer)this.getParent();
        for (BCloudHistoryExportConfig config : configs = (BCloudHistoryExportConfig[])container.getChildren(BCloudHistoryExportConfig.class)) {
            if (config instanceof BCloudHistoryAutoExportConfig) continue;
            Arrays.asList(config.getHistoryIds().getChildren(BHistoryId.class)).forEach(allHistoryIds::remove);
        }
        return allHistoryIds;
    }

    public void excludeHistoryId(BHistoryId historyId, int exclusionReason) {
        int newExclusionReason;
        if (!BCloudHistoryAutoExportConfig.isValidExclusionReason(exclusionReason)) {
            int finalExclusionReason = exclusionReason;
            log.fine(() -> String.format("Cannot exclude history id %s because exclusion reason %d is invalid", historyId.encodeToString(), finalExclusionReason));
            return;
        }
        String historyIdPropertyName = SlotPath.escape((String)historyId.encodeToString());
        BValue exclusionValue = this.getExcludedHistoryIds().get(historyIdPropertyName);
        if (exclusionValue == null) {
            this.getExcludedHistoryIds().add(historyIdPropertyName, (BValue)BInteger.make((int)exclusionReason), 1);
            return;
        }
        if (!(exclusionValue instanceof BInteger)) {
            log.fine(() -> String.format("Excluded history id %s has an invalid format; overwriting with valid format", historyId.encodeToString()));
            this.getExcludedHistoryIds().set(historyIdPropertyName, (BValue)BInteger.make((int)exclusionReason));
            return;
        }
        int existingExclusionReason = ((BNumber)exclusionValue).getInt();
        if (existingExclusionReason != (newExclusionReason = BCloudHistoryAutoExportConfig.addReasonForExclusion(existingExclusionReason, exclusionReason))) {
            this.getExcludedHistoryIds().set(historyIdPropertyName, (BValue)BInteger.make((int)newExclusionReason));
        }
    }

    public void excludeHistoryIds(List<BHistoryId> historyIds, int exclusionReason) {
        for (BHistoryId historyId : historyIds) {
            this.excludeHistoryId(historyId, exclusionReason);
        }
    }

    public void removeExclusion(BHistoryId historyId, int exclusionReason) {
        if (!BCloudHistoryAutoExportConfig.isValidExclusionReason(exclusionReason)) {
            int finalExclusionReason = exclusionReason;
            log.fine(() -> String.format("Cannot remove exclusion for history id %s because exclusion reason %d is invalid", historyId.encodeToString(), finalExclusionReason));
            return;
        }
        String historyIdPropertyName = SlotPath.escape((String)historyId.encodeToString());
        BValue exclusionValue = this.getExcludedHistoryIds().get(historyIdPropertyName);
        if (exclusionValue == null) {
            return;
        }
        if (!(exclusionValue instanceof BInteger)) {
            log.fine(() -> String.format("Cannot remove exclusion for history id %s because it is stored in an invalid format", historyId.encodeToString()));
            return;
        }
        int existingExclusionReason = ((BNumber)exclusionValue).getInt();
        if (BCloudHistoryAutoExportConfig.isExcludedOnlyForReason(existingExclusionReason, exclusionReason)) {
            this.getExcludedHistoryIds().remove(historyIdPropertyName);
        } else if (BCloudHistoryAutoExportConfig.isExcludedForReason(existingExclusionReason, exclusionReason)) {
            int newExclusionReason = BCloudHistoryAutoExportConfig.removeReasonForExclusion(existingExclusionReason, exclusionReason);
            this.getExcludedHistoryIds().set(historyIdPropertyName, (BValue)BInteger.make((int)newExclusionReason));
        }
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BCloudHistoryExportConfigContainer.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        try (SlotCursor slots = parent.getProperties();){
            while (slots.next(((Object)((Object)this)).getClass())) {
                if (slots.get() == this || this.getPropertyInParent() != null && !this.getPropertyInParent().isDynamic()) continue;
                throw new IllegalChildException("cloudLink", "history.export.illegalDuplicate.type", new Object[]{this.getType()});
            }
        }
    }

    public void updateExcludedHistoryIdsVectors() {
        BVector excludedHistoryIds = this.getExcludedHistoryIds();
        ArrayList<BVector> historyIdsVectors = new ArrayList<BVector>();
        BCloudHistoryExportConfigContainer container = (BCloudHistoryExportConfigContainer)this.getParent();
        for (BCloudHistoryExportConfig exportConfig : (BCloudHistoryExportConfig[])container.getChildren(BCloudHistoryExportConfig.class)) {
            if (exportConfig instanceof BCloudHistoryAutoExportConfig) continue;
            historyIdsVectors.add(exportConfig.getHistoryIds());
        }
        Set<BHistoryId> historyIdsToExclude = this.findHistoryIdsToExclude();
        for (Property property : excludedHistoryIds.getPropertiesArray()) {
            BValue value = excludedHistoryIds.get(property);
            if (value instanceof BHistoryId) {
                BHistoryId historyId = (BHistoryId)value;
                log.fine(() -> String.format("Excluded history id %s is in old format; updating to new format", historyId.encodeToString()));
                excludedHistoryIds.set(property, (BValue)BInteger.make((int)2));
                excludedHistoryIds.rename(property, SlotPath.escape((String)historyId.encodeToString()));
                continue;
            }
            if (!(value instanceof BInteger)) {
                log.fine(() -> String.format("Excluded history id %s has an invalid format; expected BInteger", property.getName()));
                continue;
            }
            int exclusionReason = ((BNumber)value).getInt();
            if (!BCloudHistoryAutoExportConfig.isExcludedForReason(exclusionReason, 1) || historyIdsToExclude.contains(BHistoryId.make((String)SlotPath.unescape((String)property.getName())))) continue;
            if (BCloudHistoryAutoExportConfig.isExcludedOnlyForReason(exclusionReason, 1)) {
                excludedHistoryIds.remove(property);
                continue;
            }
            exclusionReason = BCloudHistoryAutoExportConfig.removeReasonForExclusion(exclusionReason, 1);
            excludedHistoryIds.set(property, (BValue)BInteger.make((int)exclusionReason));
        }
        for (BHistoryId historyIdToExclude : historyIdsToExclude) {
            String propertyName = SlotPath.escape((String)historyIdToExclude.encodeToString());
            if (excludedHistoryIds.get(propertyName) == null) {
                excludedHistoryIds.add(propertyName, (BValue)BInteger.make((int)1), 1);
            } else {
                BValue value = excludedHistoryIds.get(propertyName);
                if (!(value instanceof BInteger)) {
                    log.fine(() -> String.format("Excluded history id %s has an invalid format; overwriting with valid format", propertyName));
                    excludedHistoryIds.remove(propertyName);
                    excludedHistoryIds.add(propertyName, (BValue)BInteger.make((int)1), 1);
                    continue;
                }
                int exclusionReason = ((BNumber)excludedHistoryIds.get(propertyName)).getInt();
                if (!BCloudHistoryAutoExportConfig.isExcludedForReason(exclusionReason, 1)) {
                    excludedHistoryIds.set(propertyName, (BValue)BInteger.make((int)BCloudHistoryAutoExportConfig.addReasonForExclusion(exclusionReason, 1)));
                }
            }
            for (BVector historyIdsVector : historyIdsVectors) {
                for (Property property : historyIdsVector.getPropertiesArray()) {
                    if (!historyIdsVector.get(property).equals((Object)historyIdToExclude)) continue;
                    historyIdsVector.remove(property);
                }
            }
        }
    }

    public static boolean isExcludedForReason(int exclusion, int exclusionReason) {
        return BCloudHistoryAutoExportConfig.isValidExclusionReason(exclusion) && BCloudHistoryAutoExportConfig.isValidExclusionReason(exclusionReason) && (exclusion & exclusionReason) != 0;
    }

    public static boolean isExcludedOnlyForReason(int exclusion, int exclusionReason) {
        return BCloudHistoryAutoExportConfig.isValidExclusionReason(exclusion) && BCloudHistoryAutoExportConfig.isValidExclusionReason(exclusionReason) && exclusion == exclusionReason;
    }

    public static int addReasonForExclusion(int exclusion, int exclusionReasonToAdd) {
        if (!BCloudHistoryAutoExportConfig.isValidExclusionReason(exclusion)) {
            exclusion = 0;
        }
        if (!BCloudHistoryAutoExportConfig.isValidExclusionReason(exclusionReasonToAdd)) {
            exclusionReasonToAdd = 0;
        }
        return exclusion | exclusionReasonToAdd;
    }

    public static int removeReasonForExclusion(int exclusion, int exclusionReasonToRemove) {
        if (!BCloudHistoryAutoExportConfig.isValidExclusionReason(exclusion)) {
            exclusion = 0;
        }
        if (!BCloudHistoryAutoExportConfig.isValidExclusionReason(exclusionReasonToRemove)) {
            exclusionReasonToRemove = 0;
        }
        return exclusion & ~exclusionReasonToRemove;
    }

    protected static boolean isValidExclusionReason(int exclusionReason) {
        return exclusionReason > 0 && exclusionReason <= 7;
    }

    protected Set<BHistoryId> findHistoryIdsToExclude() {
        HashSet<BHistoryId> excludedHistoryIds = new HashSet<BHistoryId>();
        BQueryResult excludedEntities = (BQueryResult)BOrd.make((String)"neql:nc:excluded").get((BObject)Sys.getStation());
        try (TableCursor cursor = excludedEntities.cursor();){
            while (cursor.next()) {
                BIEntity entity = (BIEntity)cursor.get();
                if (entity instanceof BHistoryExt) {
                    BHistoryExt historyExt = (BHistoryExt)entity;
                    excludedHistoryIds.add(historyExt.getHistoryConfig().getId());
                    continue;
                }
                if (entity.getType().is(CloudLinkConstants.NIAGARA_SYSTEM_HISTORY_IMPORT_TYPEINFO)) continue;
                if (entity instanceof BHistoryImport) {
                    BHistoryImport historyImport = (BHistoryImport)entity;
                    BHistoryId historyId = historyImport.getHistoryId().fromShorthand(historyImport.getDevice().getName());
                    excludedHistoryIds.add(historyId);
                    continue;
                }
                if (entity instanceof BAbstractAuditHistorySource) {
                    BAbstractAuditHistorySource auditHistorySource = (BAbstractAuditHistorySource)entity;
                    excludedHistoryIds.add(auditHistorySource.getHistoryConfig().getId());
                    continue;
                }
                if (!(entity instanceof BLogHistoryService)) continue;
                BLogHistoryService logHistoryService = (BLogHistoryService)entity;
                excludedHistoryIds.add(logHistoryService.getHistoryConfig().getId());
            }
        }
        return excludedHistoryIds;
    }
}

