/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.heartbeat;

import com.tridium.cloudLink.channel.BHeartbeatChannel;
import com.tridium.cloudLink.heartbeat.BHeartbeatPolicyContainer;
import com.tridium.cloudLink.msg.ISendHeartbeatHandler;
import com.tridium.cloudLink.transport.BAbstractConnectedTransport;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IConnectionCallback;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
public abstract class BHeartbeatPolicy
extends BAbstractDescriptor
implements IConnectionCallback {
    public static final Type TYPE = Sys.loadType(BHeartbeatPolicy.class);
    protected static final Logger log = Logger.getLogger("cloudLink.channel.heartbeat");
    private BHeartbeatPolicyContainer container;

    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 12: {
                this.fwStopped();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        BAbstractTransport transport = this.getContainer().getChannel().getChannelConfig().getTransport(this.getOperationId());
        if (transport instanceof BAbstractConnectedTransport) {
            this.getExecutionTime().setNextTrigger(BAbsTime.END_OF_TIME);
            ((BAbstractConnectedTransport)transport).addConnectionCallback(this);
        }
    }

    private void fwStopped() {
        this.container = null;
    }

    @Override
    public void onConnect() {
        if (Sys.atSteadyState()) {
            this.getExecutionTime().checkTime();
        }
    }

    @Override
    public void onDisconnect() {
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        ((BHeartbeatPolicyContainer)this.getParent().as(BHeartbeatPolicyContainer.class)).getAsyncWorkQueue().enqueue((Object)new Invocation((BComponent)this, action, arg, cx));
        return null;
    }

    public void updateStatus() {
        if (!this.isRunning()) {
            return;
        }
        int newStatus = this.getStatus().getBits();
        BHeartbeatChannel channel = this.getContainer().getChannel();
        newStatus = !this.getEnabled() || channel != null && channel.getStatus().isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = channel == null || !this.getLastFailure().isNull() && this.getLastFailure().isAfter(this.getLastSuccess()) ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.getStatus().getBits()) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
    }

    public void executeOk() {
        this.setFaultCause("");
        this.setLastSuccess(Clock.time());
        this.setState(BDescriptorState.idle);
        this.updateStatus();
    }

    public final void executeFail(String reason) {
        if (reason == null) {
            reason = "";
        }
        this.setLastFailure(Clock.time());
        this.setFaultCause(reason);
        this.setState(BDescriptorState.idle);
        this.updateStatus();
    }

    public abstract Map<String, Object> getPayloadProperties();

    public String getOperationId() {
        return ISendHeartbeatHandler.getOperationId();
    }

    public final BHeartbeatPolicyContainer getContainer() {
        if (this.container == null) {
            this.container = (BHeartbeatPolicyContainer)this.getParent();
        }
        if (this.container == null) {
            throw new IllegalStateException("getContainer() called on unmounted policy object");
        }
        return this.container;
    }
}

