/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.command;

import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.command.BBaseTagCommand;
import java.util.Optional;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Relations;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.tagdictionary.BTagGroupInfo;

@NiagaraType
public class BWriteTagGroupCommand
extends BBaseTagCommand {
    public static final Type TYPE = Sys.loadType(BWriteTagGroupCommand.class);
    public static final String MSG_TEMPLATE = "WriteTagGroupCommand: %s [cloud id %s], %s command [msg id %s]";
    private final Id tagGroupId = Id.newId((String)"n:tagGroup");

    @Override
    public Type getType() {
        return TYPE;
    }

    protected boolean writeTagGroup(String messageId, String cloudId, String namespace, String tagGroup, Context cx) {
        BIObject entity = CloudLinkUtils.findEntity(messageId, cloudId);
        if (!(entity instanceof Entity) || !BWriteTagGroupCommand.isWriteAllowed(entity, cx)) {
            log.info(() -> String.format(MSG_TEMPLATE, "Insufficient permissions for entity", cloudId, "aborting", messageId));
            return false;
        }
        if (this.excludedNamespaceSet.contains(namespace)) {
            log.info(() -> String.format(MSG_TEMPLATE, "Writes of tags contained in " + namespace + " are not allowed.", cloudId, "aborting", messageId));
            return false;
        }
        BTagDictionaryService dictionaryService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
        Optional optDictionary = dictionaryService.getTagDictionary(namespace);
        if (!optDictionary.isPresent()) {
            log.info(() -> String.format(MSG_TEMPLATE, "Unable to locate tag dictionary with namespace " + namespace, cloudId, "aborting", messageId));
            return false;
        }
        BTagDictionary dictionary = (BTagDictionary)optDictionary.get();
        Id tagGroupName = Id.newId((String)namespace, (String)tagGroup);
        Optional optTagGroupInfo = dictionary.getTagGroupDefinitions().getTagGroup(tagGroupName);
        if (!optTagGroupInfo.isPresent()) {
            log.info(() -> String.format(MSG_TEMPLATE, "Unable to locate tag group with name " + tagGroup + " in namespace " + namespace, cloudId, "aborting", messageId));
            return false;
        }
        BTagGroupInfo info = (BTagGroupInfo)optTagGroupInfo.get();
        Relations relations = ((Entity)entity).relations();
        for (Relation relation : relations.getAll(this.tagGroupId)) {
            if (relation.getEndpoint() != info) continue;
            return true;
        }
        BRelation relation = new BRelation(this.tagGroupId, info.getSlotPathOrd());
        if (relations.add((Relation)relation) == null) {
            return false;
        }
        BComplex parent = relation.getParent();
        Property property = relation.getPropertyInParent();
        parent.setFlags((Slot)property, 1);
        parent.setFacets((Slot)property, BFacets.make((String)"tg__", (boolean)true));
        return true;
    }
}

