/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.command;

import com.tridium.clUtils.util.TagUtil;
import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.command.BCloudWriteInfo;
import com.tridium.cloudLink.command.BCommand;
import com.tridium.cloudLink.command.BWritePointCommand;
import com.tridium.cloudLink.msg.PointInputResult;
import java.util.Arrays;
import java.util.Optional;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.baja.control.BControlPoint;
import javax.baja.control.BIWritablePoint;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;

@NiagaraType
public abstract class BReadPointInputPropertiesCommand
extends BCommand {
    public static final Type TYPE = Sys.loadType(BReadPointInputPropertiesCommand.class);
    private static final int[] PRIORITY_ORDINALS;
    private static final String PROPERTY_MESSAGE = "Could not obtain input property for message id %s and point %s with id %s for priority %s.";

    @Override
    public Type getType() {
        return TYPE;
    }

    protected TreeMap<BPriorityLevel, PointInputResult> getInputProperties(String messageId, String pointId, Context cx) {
        BStatusValue fallBackStatusValue;
        Property fallbackProp;
        if (pointId == null || pointId.isEmpty()) {
            return null;
        }
        BControlPoint point = CloudLinkUtils.findPoint(messageId, pointId);
        if (point == null) {
            return null;
        }
        if (!this.isLicensed(point)) {
            liclog.warning(() -> String.format("ReadPointInputPropertiesCommand: point %s not licensed", pointId));
            return null;
        }
        if (!(point instanceof BIWritablePoint) || !CloudLinkUtils.isPointReadAllowed(point, cx)) {
            return null;
        }
        BIWritablePoint wrtPt = (BIWritablePoint)point.as(BIWritablePoint.class);
        TreeMap<BPriorityLevel, PointInputResult> inputs = new TreeMap<BPriorityLevel, PointInputResult>();
        for (int ordinal : PRIORITY_ORDINALS) {
            BPriorityLevel priorityLevel = BPriorityLevel.make((int)ordinal);
            try {
                Property inProp;
                BStatusValue inStatusValue = wrtPt.getInStatusValue(priorityLevel);
                if (inStatusValue == null || (inProp = wrtPt.getInProperty(priorityLevel)) == null) continue;
                BAbsTime expiration = BAbsTime.NULL;
                String source = "";
                if (priorityLevel.equals((Object)BPriorityLevel.level_8)) {
                    expiration = BReadPointInputPropertiesCommand.getOverrideExpiration(point).orElse(BAbsTime.NULL);
                } else {
                    Optional<BCloudWriteInfo> writeInfoOpt = BReadPointInputPropertiesCommand.getCloudWriteInfo(point, ordinal);
                    if (writeInfoOpt.isPresent()) {
                        BCloudWriteInfo writeInfo = writeInfoOpt.get();
                        expiration = writeInfo.getExpiration();
                        source = writeInfo.getSource();
                    } else {
                        source = this.getSourceCloudId(point, inProp).orElse((BIDataValue)BString.DEFAULT).toString();
                    }
                }
                inputs.put(priorityLevel, new PointInputResult(inStatusValue, expiration, source));
            }
            catch (Exception ex) {
                log.log(Level.FINEST, String.format(PROPERTY_MESSAGE, messageId, point.getDisplayName(cx), TagUtil.getCloudId((BComponent)point), priorityLevel), log.isLoggable(Level.FINE) ? ex : null);
            }
        }
        BValue fallbackValue = point.get("fallback");
        if (fallbackValue instanceof BStatusValue && (fallbackProp = (fallBackStatusValue = (BStatusValue)fallbackValue.as(BStatusValue.class)).getPropertyInParent()) != null) {
            String source = this.getSourceCloudId(point, fallbackProp).orElse((BIDataValue)BString.DEFAULT).toString();
            inputs.put(BPriorityLevel.fallback, new PointInputResult(fallBackStatusValue, BAbsTime.NULL, source));
        }
        return inputs;
    }

    private static Optional<BCloudWriteInfo> getCloudWriteInfo(BControlPoint point, int priority) {
        String cloudWriteInfoName = BWritePointCommand.getCloudWriteNameForPriority(String.valueOf(priority));
        BValue value = point.get(cloudWriteInfoName);
        if (value instanceof BCloudWriteInfo) {
            return Optional.of(value.as(BCloudWriteInfo.class));
        }
        return Optional.empty();
    }

    private static Optional<BAbsTime> getOverrideExpiration(BControlPoint point) {
        BValue value = point.get("overrideExpiration");
        if (value instanceof BAbsTime) {
            return Optional.of(value.as(BAbsTime.class));
        }
        return Optional.empty();
    }

    protected Optional<BIDataValue> getSourceCloudId(BControlPoint point, Property inputProperty) {
        return Arrays.stream(point.getLinks((Slot)inputProperty)).filter(l -> l.isInbound() && TagUtil.hasCloudId((BIEntity)l.getSourceComponent())).findFirst().flatMap(l -> TagUtil.getCloudId((BComponent)l.getSourceComponent()));
    }

    static {
        int[] priorityOrdinals = BPriorityLevel.DEFAULT.getRange().getOrdinals();
        PRIORITY_ORDINALS = Arrays.copyOfRange(priorityOrdinals, 1, 17);
    }
}

