/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.command;

import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.command.BBaseTagCommand;
import java.util.Optional;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Relations;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagDictionaryService;

@NiagaraType
public class BDeleteRelationCommand
extends BBaseTagCommand {
    public static final Type TYPE = Sys.loadType(BDeleteRelationCommand.class);
    public static final String MSG_TEMPLATE = "DeleteRelationCommand: %s [source cloud id %s], [target cloud id %s], %s command [msg id %s]";

    @Override
    public Type getType() {
        return TYPE;
    }

    protected boolean deleteRelation(String messageId, String sourceCloudId, String targetCloudId, String namespace, String relationName, Context cx) {
        BIObject sourceEntity = CloudLinkUtils.findEntity(messageId, sourceCloudId);
        if (!(sourceEntity instanceof Entity) || !BDeleteRelationCommand.isWriteAllowed(sourceEntity, cx)) {
            log.info(() -> String.format(MSG_TEMPLATE, "Insufficient permissions for source entity", sourceCloudId, targetCloudId, "aborting", messageId));
            return false;
        }
        BIObject targetEntity = CloudLinkUtils.findEntity(messageId, targetCloudId);
        if (!(targetEntity instanceof Entity) || !BDeleteRelationCommand.isWriteAllowed(targetEntity, cx)) {
            log.info(() -> String.format(MSG_TEMPLATE, "Insufficient permissions for target entity", sourceCloudId, targetCloudId, "aborting", messageId));
            return false;
        }
        if (this.excludedNamespaceSet.contains(namespace)) {
            log.info(() -> String.format(MSG_TEMPLATE, "Deletes of relations contained in " + namespace + " are not allowed.", sourceCloudId, targetCloudId, "aborting", messageId));
            return false;
        }
        BTagDictionaryService dictionaryService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
        Optional optDictionary = dictionaryService.getTagDictionary(namespace);
        if (!optDictionary.isPresent()) {
            log.info(() -> String.format(MSG_TEMPLATE, "Unable to locate tag dictionary with namespace " + namespace, sourceCloudId, targetCloudId, "aborting", messageId));
            return false;
        }
        BTagDictionary dictionary = (BTagDictionary)optDictionary.get();
        Id relationId = Id.newId((String)namespace, (String)relationName);
        Optional optRelationInfo = dictionary.getRelationDefinitions().getRelation(relationId);
        if (!optRelationInfo.isPresent()) {
            log.info(() -> String.format(MSG_TEMPLATE, "Unable to locate relation with name " + relationName + " in namespace " + namespace, sourceCloudId, targetCloudId, "aborting", messageId));
            return false;
        }
        Relations relations = ((Entity)sourceEntity).relations();
        for (Relation relation : relations.getAll(relationId)) {
            if (relation.getEndpoint() != targetEntity) continue;
            return targetEntity instanceof BComponent ? relations.remove((Relation)new BRelation(relationId, ((BComponent)targetEntity).getSlotPathOrd())) : false;
        }
        return true;
    }
}

