/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.command;

import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.CloudLinkUtils;
import com.tridium.cloudLink.command.BCloudWriteInfo;
import com.tridium.cloudLink.command.BCommand;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BClearPointCommand
extends BCommand {
    public static final Type TYPE = Sys.loadType(BClearPointCommand.class);
    public static final String AUTO = "auto";
    public static final String MSG_TEMPLATE = "ClearPointCommand: %s [cloud id %s], %s command [msg id %s]";

    @Override
    public Type getType() {
        return TYPE;
    }

    protected boolean clearPoint(String messageId, String pointId, int priority, Context cx) {
        if (priority < 2 || priority > 16) {
            log.info("Attempt to clear point with invalid priority, aborting " + messageId);
            return false;
        }
        BControlPoint point = CloudLinkUtils.findPoint(messageId, pointId);
        if (point == null) {
            return false;
        }
        if (!this.isLicensed(point)) {
            liclog.warning(() -> String.format("ClearPointCommand: point %s not licensed", pointId));
            return false;
        }
        if (!CloudLinkUtils.isPointWriteAllowed(point, cx)) {
            log.info("Insufficient permissions to clear point, aborting " + messageId);
            return false;
        }
        if (priority == 8) {
            Optional levelsDvOpt = point.tags().get(CloudLinkConstants.WRITABLE_LEVELS);
            if (!levelsDvOpt.isPresent() || !(levelsDvOpt.get() instanceof BString)) {
                log.info(() -> {
                    String msg = String.format("Not permitted, missing %s tag or it's not a string type for point", "nc:writableLevels");
                    return String.format(MSG_TEMPLATE, msg, pointId, "aborting", messageId);
                });
                return false;
            }
            String levels = ((BString)((BIDataValue)levelsDvOpt.get()).as(BString.class)).getString().trim();
            String[] levelValues = levels.split(",");
            if (!Stream.of(levelValues).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.toList()).contains(Integer.toString(priority))) {
                log.info(() -> {
                    String msg = String.format("Not permitted at priority %s as it's not in tag %s for point", priority, "nc:writableLevels");
                    return String.format(MSG_TEMPLATE, msg, pointId, "aborting", messageId);
                });
                return false;
            }
            Action action = point.getAction(AUTO);
            try {
                point.invoke(action, null, cx);
                actionLog.config(() -> String.format("Message id %s: point id %s cleared at manual auto by %s", messageId, pointId, cx.getUser().getUsername()));
                return true;
            }
            catch (ActionInvokeException | LocalizableRuntimeException exception) {
                log.fine(() -> BClearPointCommand.lambda$clearPoint$5((BajaRuntimeException)exception, pointId, messageId));
                return false;
            }
        }
        String targetName = "In" + priority;
        String name = "cloudWrite" + targetName;
        Property property = point.getProperty(name);
        if (property == null) {
            log.info("Attempt to clear point at priority level that is not set " + messageId);
            return false;
        }
        BValue value = point.get(property);
        if (!(value instanceof BCloudWriteInfo)) {
            log.info(() -> String.format("Unexpected object type %s in cloud write property %s", value.getType().getDisplayName(null), messageId));
            return false;
        }
        ((BCloudWriteInfo)value).doClearCloudWrite();
        actionLog.config(() -> String.format("Message id %s: point id %s is being cleared at %s by %s", messageId, pointId, targetName, cx.getUser().getUsername()));
        return true;
    }

    private static /* synthetic */ String lambda$clearPoint$5(BajaRuntimeException exception, String pointId, String messageId) {
        return String.format(MSG_TEMPLATE, "Auto action failed: " + exception.getMessage(), pointId, "aborting", messageId);
    }
}

