/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.msg.IExportScheduleHandler;
import com.tridium.cloudLink.schedule.BCloudScheduleExportPolicy;
import com.tridium.cloudLink.schedule.BCloudScheduleImportPolicy;
import com.tridium.cloudLink.schedule.BCloudSchedulePolicyContainer;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.MessageWrapper;
import java.io.IOException;
import java.security.AccessController;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="channelType", type="BString", defaultValue="BString.make(CLOUD_LINK_CHANNEL_SCHEDULE)", flags=1, override=true), @NiagaraProperty(name="policies", type="BCloudSchedulePolicyContainer", defaultValue="new BCloudSchedulePolicyContainer()", flags=256)})
public class BScheduleChannel
extends BAbstractClientChannel {
    public static final Property channelType = BScheduleChannel.newProperty((int)1, (BValue)BString.make((String)"Schedule"), null);
    public static final Property policies = BScheduleChannel.newProperty((int)256, (BValue)new BCloudSchedulePolicyContainer(), null);
    public static final Type TYPE = Sys.loadType(BScheduleChannel.class);
    private static final String SEND_SCHEDULE_ERROR = "Could not import/export schedules";
    private static final Logger log = Logger.getLogger("cloudLink.channel.schedule");

    public BCloudSchedulePolicyContainer getPolicies() {
        return (BCloudSchedulePolicyContainer)this.get(policies);
    }

    public void setPolicies(BCloudSchedulePolicyContainer v) {
        this.set(policies, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("ScheduleChannel.icon"));
    }

    @Override
    protected void propagateStatus() {
        BCloudScheduleImportPolicy[] importPolicies;
        BCloudScheduleExportPolicy[] exportPolicies;
        super.propagateStatus();
        BCloudSchedulePolicyContainer container = this.getPolicies();
        for (BCloudScheduleExportPolicy exportPolicy : exportPolicies = (BCloudScheduleExportPolicy[])container.getChildren(BCloudScheduleExportPolicy.class)) {
            exportPolicy.updateStatus();
        }
        for (BCloudScheduleImportPolicy importPolicy : importPolicies = (BCloudScheduleImportPolicy[])container.getChildren(BCloudScheduleImportPolicy.class)) {
            importPolicy.updateStatus();
        }
    }

    public CompletableFuture<Void> exportSchedule(BCloudScheduleExportPolicy policy) {
        CompletableFuture<Void> channelFuture = new CompletableFuture<Void>();
        Optional<String> errMsg = this.checkChannelConfig();
        if (errMsg.isPresent()) {
            channelFuture.completeExceptionally(new IllegalStateException(errMsg.get()));
            return channelFuture;
        }
        try {
            BCloudConnectionService connectionService = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service."));
            BChannelConfig config = this.getChannelConfig();
            BAbstractTransport transport = config.getTransport(IExportScheduleHandler.getOperationId());
            if (!transport.canSend()) {
                throw new IOException("Transport unable to send messages");
            }
            BAbstractCloudLinkHandlerFactory msgFactory = connectionService.getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
            IExportScheduleHandler exportScheduleHandler = msgFactory.getMessageHandler(IExportScheduleHandler.class, config);
            exportScheduleHandler.add(policy.getSchedule());
            IMessage message = exportScheduleHandler.toMessage(true);
            if (message == null) {
                exportScheduleHandler.getFuture(channelFuture, null);
            } else {
                MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(message, exportScheduleHandler.getFuture(channelFuture), transport.getMessageRetries());
                AccessController.doPrivileged(() -> {
                    config.enqueueMessage(IExportScheduleHandler.getOperationId(), wrapper);
                    return null;
                });
                transport.notifyPending();
            }
        }
        catch (Exception except) {
            log.log(Level.WARNING, String.format("Schedule export for policy %s failed: %s", policy.getDisplayName(null), except.getMessage()), log.isLoggable(Level.FINE) ? except : null);
            channelFuture.completeExceptionally(except);
        }
        return channelFuture;
    }

    public CompletableFuture<Void> importSchedule(BCloudScheduleImportPolicy policy) {
        return CompletableFuture.completedFuture(null);
    }

    private Optional<String> checkChannelConfig() {
        StringBuilder err = this.checkChannelConfigCommon(SEND_SCHEDULE_ERROR);
        return err.length() > 0 ? Optional.of(err.substring(0, err.length() - 1)) : Optional.empty();
    }
}

