/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.BCloudConnectionService;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.msg.ISendPointValuesHandler;
import com.tridium.cloudLink.points.BPointExportPolicy;
import com.tridium.cloudLink.points.BPointExportPolicyContainer;
import com.tridium.cloudLink.points.CovRecord;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.MessageWrapper;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="channelType", type="BString", defaultValue="BString.make(CLOUD_LINK_CHANNEL_POINT)", flags=1, override=true), @NiagaraProperty(name="policies", type="BPointExportPolicyContainer", defaultValue="new BPointExportPolicyContainer()", flags=256)})
public class BPointsChannel
extends BAbstractClientChannel {
    public static final Property channelType = BPointsChannel.newProperty((int)1, (BValue)BString.make((String)"Point"), null);
    public static final Property policies = BPointsChannel.newProperty((int)256, (BValue)new BPointExportPolicyContainer(), null);
    public static final Type TYPE = Sys.loadType(BPointsChannel.class);
    private static final String SEND_POINTS_ERROR = "Could not send points";
    private static final Logger liclog = Logger.getLogger("cloudLink.license");
    private static final Logger licdbg = Logger.getLogger("cloudLink.license.debug");

    public BPointExportPolicyContainer getPolicies() {
        return (BPointExportPolicyContainer)this.get(policies);
    }

    public void setPolicies(BPointExportPolicyContainer v) {
        this.set(policies, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("PointsChannel.icon"));
    }

    @Override
    protected void propagateStatus() {
        BPointExportPolicyContainer[] containers;
        super.propagateStatus();
        for (BPointExportPolicyContainer container : containers = (BPointExportPolicyContainer[])this.getChildren(BPointExportPolicyContainer.class)) {
            BPointExportPolicy[] policies;
            for (BPointExportPolicy policy : policies = (BPointExportPolicy[])container.getChildren(BPointExportPolicy.class)) {
                policy.updateStatus();
            }
        }
    }

    public List<CompletableFuture<Boolean>> sendPoints(BPointExportPolicy policy) {
        Optional<String> errMsg = this.checkChannelConfig();
        ArrayList<CompletableFuture<Boolean>> rv = new ArrayList<CompletableFuture<Boolean>>();
        if (errMsg.isPresent()) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new IllegalStateException(errMsg.get()));
            rv.add(future);
            return rv;
        }
        BAbstractTransport transport = this.getChannelConfig().getTransport(ISendPointValuesHandler.getOperationId());
        if (!transport.canSend()) {
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            future.complete(false);
            rv.add(future);
            return rv;
        }
        BCloudConnectionService cloudConnectionService = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service."));
        BAbstractCloudLinkHandlerFactory msgFactory = cloudConnectionService.getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        BChannelConfig config = this.getChannelConfig();
        ISendPointValuesHandler pointValuesHandler = msgFactory.getMessageHandler(ISendPointValuesHandler.class, config);
        while (policy.hasNext()) {
            BIObject bObject = policy.next();
            if (BCloudConnectionService.isLicensed(bObject)) {
                if (pointValuesHandler.add(bObject) < config.getMaxMessageSize(ISendPointValuesHandler.getOperationId())) continue;
                rv.add(this.sendMessage(pointValuesHandler, transport, false));
                continue;
            }
            liclog.info(() -> String.format("Unlicensed point %s not added to channel snapshot update", bObject));
        }
        if (pointValuesHandler.hasData()) {
            rv.add(this.sendMessage(pointValuesHandler, transport, true));
        }
        return rv;
    }

    public List<CompletableFuture<Boolean>> sendPoints(CovRecord[] records) {
        Optional<String> errMsg = this.checkChannelConfig();
        ArrayList<CompletableFuture<Boolean>> rv = new ArrayList<CompletableFuture<Boolean>>();
        if (errMsg.isPresent()) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new IllegalStateException(errMsg.get()));
            rv.add(future);
            return rv;
        }
        BAbstractTransport transport = this.getChannelConfig().getTransport(ISendPointValuesHandler.getOperationId());
        if (!transport.canSend()) {
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            future.complete(false);
            rv.add(future);
            return rv;
        }
        BCloudConnectionService cloudConnectionService = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service."));
        BAbstractCloudLinkHandlerFactory msgFactory = cloudConnectionService.getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        BChannelConfig config = this.getChannelConfig();
        ISendPointValuesHandler pointValuesHandler = msgFactory.getMessageHandler(ISendPointValuesHandler.class, config);
        for (CovRecord record : records) {
            if (BCloudConnectionService.isLicensed(record.getId(), "point.limit")) {
                if (pointValuesHandler.add(record) < config.getMaxMessageSize(ISendPointValuesHandler.getOperationId())) continue;
                rv.add(this.sendMessage(pointValuesHandler, transport, false));
                continue;
            }
            liclog.info(() -> String.format("CovRecord for unlicensed id %s not added to channel snapshot update", record.getId()));
        }
        if (pointValuesHandler.hasData()) {
            rv.add(this.sendMessage(pointValuesHandler, transport, true));
        }
        return rv;
    }

    private CompletableFuture<Boolean> sendMessage(ISendPointValuesHandler pointValuesHandler, BAbstractTransport transport, boolean isFinal) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(pointValuesHandler.toMessage(isFinal), pointValuesHandler.getFuture(future), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            this.getChannelConfig().enqueueMessage(ISendPointValuesHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return future;
    }

    private Optional<String> checkChannelConfig() {
        StringBuilder err = this.checkChannelConfigCommon(SEND_POINTS_ERROR);
        return err.length() > 0 ? Optional.of(err.substring(0, err.length() - 1)) : Optional.empty();
    }
}

