/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BMultiTransportChannelConfig;
import com.tridium.cloudLink.channel.BTransportConfig;
import com.tridium.cloudLink.transport.BAbstractConnectedTransport;
import com.tridium.cloudLink.transport.BAbstractTransport;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="authenticatorId", type="BString", defaultValue="BString.DEFAULT", flags=1)
@NiagaraAction(name="configureTransports")
public abstract class BMessageChannelConfig
extends BMultiTransportChannelConfig {
    public static final Property authenticatorId = BMessageChannelConfig.newProperty((int)1, (BValue)BString.DEFAULT, null);
    public static final Action configureTransports = BMessageChannelConfig.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BMessageChannelConfig.class);

    public String getAuthenticatorId() {
        return this.getString(authenticatorId);
    }

    public void setAuthenticatorId(String v) {
        this.setString(authenticatorId, v, null);
    }

    public void configureTransports() {
        this.invoke(configureTransports, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.doConfigureTransports();
    }

    public void doConfigureTransports() {
        ((BAbstractClientChannel)this.getParent()).getConnectionService().ifPresent(ccs -> {
            for (BAbstractTransport transport : ccs.getTransports().getTransports()) {
                String transType = transport.getTransportType();
                if (this.getProperty(transType) != null) continue;
                String authenticatorId = this.getAuthenticatorId();
                if (transport instanceof BAbstractConnectedTransport) {
                    authenticatorId = ((BAbstractConnectedTransport)transport).getAuthenticatorId();
                }
                this.add(transType, (BValue)new BTransportConfig(transport.getTransportType(), authenticatorId));
            }
            this.registerOps();
        });
    }
}

