/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloudLink.channel;

import com.tridium.cloudLink.BAbstractCloudLinkHandlerFactory;
import com.tridium.cloudLink.CloudLinkConstants;
import com.tridium.cloudLink.channel.BAbstractClientChannel;
import com.tridium.cloudLink.channel.BChannelConfig;
import com.tridium.cloudLink.channel.BIHistoryChannelConfig;
import com.tridium.cloudLink.file.FileUploadRequest;
import com.tridium.cloudLink.file.FileUploader;
import com.tridium.cloudLink.history.BCloudHistoryAutoExportConfig;
import com.tridium.cloudLink.history.BCloudHistoryExportConfig;
import com.tridium.cloudLink.history.BCloudHistoryExportConfigContainer;
import com.tridium.cloudLink.history.BHistoryChannelState;
import com.tridium.cloudLink.history.BHistoryUpdateMode;
import com.tridium.cloudLink.history.CompositeGetLastTimestampsResult;
import com.tridium.cloudLink.history.HistoryBatchIterator;
import com.tridium.cloudLink.history.HistoryBatchWrapper;
import com.tridium.cloudLink.history.HistoryItemBatchContainer;
import com.tridium.cloudLink.history.HistoryItemIterator;
import com.tridium.cloudLink.history.HistoryItemWrapper;
import com.tridium.cloudLink.msg.GetHistoriesResult;
import com.tridium.cloudLink.msg.GetLastTimestampsResult;
import com.tridium.cloudLink.msg.HistoryItem;
import com.tridium.cloudLink.msg.IGetHistoriesHandler;
import com.tridium.cloudLink.msg.IGetLastTimestampsHandler;
import com.tridium.cloudLink.msg.ISendBulkHistoriesHandler;
import com.tridium.cloudLink.msg.ISendHistoriesHandler;
import com.tridium.cloudLink.msg.SendHistoriesResult;
import com.tridium.cloudLink.objectIdentity.BCloudIdManager;
import com.tridium.cloudLink.objectIdentity.IIdentityManagementCallbacks;
import com.tridium.cloudLink.transport.BAbstractConnectedTransport;
import com.tridium.cloudLink.transport.BAbstractTransport;
import com.tridium.cloudLink.transport.IConnectionCallback;
import com.tridium.cloudLink.transport.IMessage;
import com.tridium.cloudLink.transport.IMessageResponse;
import com.tridium.cloudLink.transport.MessageWrapper;
import com.tridium.cloudLink.util.BCompletableFutureWrapper;
import com.tridium.util.EmptyCursor;
import com.tridium.util.EscUtil;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryException;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="channelType", type="BString", defaultValue="BString.make(CLOUD_LINK_CHANNEL_HISTORY)", flags=1, override=true), @NiagaraProperty(name="exports", type="BCloudHistoryExportConfigContainer", defaultValue="new BCloudHistoryExportConfigContainer()", flags=256), @NiagaraProperty(name="lastRecordSentTimes", type="BVector", defaultValue="new BVector()", flags=5), @NiagaraProperty(name="displayState", type="BString", defaultValue="unknown", flags=3)})
@NiagaraAction(name="cloudIdsUpdated", returnType="BCompletableFutureWrapper", flags=20)
public class BHistoriesChannel
extends BAbstractClientChannel
implements IConnectionCallback,
IIdentityManagementCallbacks {
    public static final Property channelType = BHistoriesChannel.newProperty((int)1, (BValue)BString.make((String)"History"), null);
    public static final Property exports = BHistoriesChannel.newProperty((int)256, (BValue)new BCloudHistoryExportConfigContainer(), null);
    public static final Property lastRecordSentTimes = BHistoriesChannel.newProperty((int)5, (BValue)new BVector(), null);
    public static final Property displayState = BHistoriesChannel.newProperty((int)3, (String)"unknown", null);
    public static final Action cloudIdsUpdated = BHistoriesChannel.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BHistoriesChannel.class);
    protected volatile CompletableFuture<Void> timestampInitializationFuture;
    private boolean timestampsInitialized;
    private boolean backfillError;
    private int initRetries;
    private ScheduledExecutorService scheduler;
    private Map<BHistoryId, String> telemIdsByHistoryId;
    private Map<String, BHistoryId> historyIdsByTelemId;
    private BAbsTime disconnectTime;
    private volatile BHistoryChannelState state = BHistoryChannelState.checkingBackfill;
    private static final ReentrantLock stateLock = new ReentrantLock();
    private final AtomicBoolean updateBackfill = new AtomicBoolean(false);
    public static final BCloudHistoryExportConfig[] HISTORY_EXPORT_CONFIGS = new BCloudHistoryExportConfig[0];
    private final Object updateTelemetryIdsSyncObject = new Object();
    private static final Logger log = Logger.getLogger("cloudLink.channel.history");
    private static final Logger liclog = Logger.getLogger("cloudLink.license");
    private static final Logger licdbg = Logger.getLogger("cloudLink.license.debug");
    private static final int MAX_INIT_RETRIES = 5;
    private static final long RETRY_DELAY = 5000L;
    private static final int BULK_HISTORY_LOG_FREQUENCY = 1000;
    private static final String NO_DATA = "No data supplied";
    private static final String SEND_HISTORIES_ERROR = "Could not send histories";
    private static final String GET_LAST_TIMESTAMPS_ERROR = "Could not get last timestamps";
    private static final String GET_HISTORIES_ERROR = "Could not get histories";

    public BCloudHistoryExportConfigContainer getExports() {
        return (BCloudHistoryExportConfigContainer)this.get(exports);
    }

    public void setExports(BCloudHistoryExportConfigContainer v) {
        this.set(exports, (BValue)v, null);
    }

    public BVector getLastRecordSentTimes() {
        return (BVector)this.get(lastRecordSentTimes);
    }

    public void setLastRecordSentTimes(BVector v) {
        this.set(lastRecordSentTimes, (BValue)v, null);
    }

    public String getDisplayState() {
        return this.getString(displayState);
    }

    public void setDisplayState(String v) {
        this.setString(displayState, v, null);
    }

    public BCompletableFutureWrapper cloudIdsUpdated() {
        return (BCompletableFutureWrapper)this.invoke(cloudIdsUpdated, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (p.equals(status) && this.isRunning() && this.isOperational()) {
            stateLock.lock();
            try {
                if (BHistoryChannelState.normal.equals((Object)this.state) || BHistoryChannelState.checkingBackfill.equals((Object)this.state)) {
                    this.setState(BHistoryChannelState.checkingBackfill);
                    stateLock.unlock();
                    if (!this.timestampsInitialized) {
                        this.scheduler.execute(this::initializeChannel);
                    } else {
                        this.doUpdateCloudIdsAndBackfillAsync();
                    }
                }
            }
            finally {
                if (stateLock.isHeldByCurrentThread()) {
                    stateLock.unlock();
                }
            }
        }
    }

    @Override
    public BIcon getIcon() {
        return BIcon.make((String)lex.getText("HistoriesChannel.icon"));
    }

    @Override
    protected final void channelStarted() {
        if (this.getConnectionService().map(BAbstractService::isFatalFault).orElse(true).booleanValue()) {
            return;
        }
        stateLock.lock();
        try {
            this.setState(BHistoryChannelState.checkingBackfill);
        }
        finally {
            stateLock.unlock();
        }
        this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("cloudLink.channel.history");
                t.setPriority(1);
                return t;
            }
        });
        this.telemIdsByHistoryId = new HashMap<BHistoryId, String>();
        this.historyIdsByTelemId = new HashMap<String, BHistoryId>();
    }

    @Override
    protected void fwDescendantsStarted() {
        super.fwDescendantsStarted();
        if (this.getConnectionService().map(ccs -> ccs.isFatalFault()).orElse(true).booleanValue()) {
            return;
        }
        this.getConnectionService().ifPresent(ccs -> ccs.registerForConnectionServiceReady(() -> {
            this.registerCallbacks();
            if (Sys.isStationStarted()) {
                this.initializeChannel();
            }
        }));
    }

    @Override
    protected void fwStopped() {
        super.fwStopped();
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        this.initializeChannel();
    }

    protected void initializeChannel() {
        this.setDisplayState(this.state.getDisplayTag(null));
        if (this.getConnectionService().map(ccs -> ccs.isFatalFault()).orElse(true).booleanValue() || !this.isOperational()) {
            return;
        }
        this.updateCloudIdsFromAllHistoryExports();
        this.initializeTimestampData();
    }

    @Override
    protected void propagateStatus() {
        BCloudHistoryExportConfigContainer[] containers;
        super.propagateStatus();
        for (BCloudHistoryExportConfigContainer container : containers = (BCloudHistoryExportConfigContainer[])this.getChildren(BCloudHistoryExportConfigContainer.class)) {
            BCloudHistoryExportConfig[] exportConfigs;
            for (BCloudHistoryExportConfig exportConfig : exportConfigs = (BCloudHistoryExportConfig[])container.getChildren(BCloudHistoryExportConfig.class)) {
                exportConfig.updateStatus();
            }
        }
    }

    public CompletableFuture<Integer> sendHistories(List<BHistoryId> historyIds) {
        if (!this.isOperational()) {
            log.warning("send histories: channel is not operational.");
            return this.sendHistoriesFailureMessage("History channel is not operational");
        }
        if (!BHistoryChannelState.normal.equals((Object)this.state)) {
            log.warning("send histories: channel is not able to send, state is " + this.state.getDisplayTag(null));
            return this.sendHistoriesFailureMessage("History channel is unable to send while " + this.state.getDisplayTag(null));
        }
        if (!this.timestampsInitialized) {
            this.initializeTimestampData();
        }
        if (this.timestampInitializationFuture != null && !this.timestampInitializationFuture.isDone()) {
            CompletableFuture<Integer> sendFuture = new CompletableFuture<Integer>();
            this.timestampInitializationFuture.whenComplete((result, error) -> this.sendHistories(historyIds).whenComplete((res, err) -> {
                if (err != null) {
                    sendFuture.completeExceptionally((Throwable)err);
                } else {
                    sendFuture.complete((Integer)res);
                }
            }));
            return sendFuture;
        }
        BChannelConfig config = this.getChannelConfig();
        if (!config.isQueueEmpty(ISendHistoriesHandler.getOperationId())) {
            log.info("pending history messages exist, skipping sendHistories");
            return this.sendHistoriesFailureMessage("Send histories was skipped as there are pending history messages");
        }
        BHistoryDatabase historyDb = this.getHistoryDb();
        if (historyDb == null) {
            log.warning("send histories: unable to get history db.");
            return this.sendHistoriesFailureMessage("Unable to get history database.");
        }
        try (HistoryDatabaseConnection conn = historyDb.getDbConnection(null);){
            CompletableFuture<Integer> completableFuture;
            HashMap<BHistoryId, BITable> historyMap = new HashMap<BHistoryId, BITable>();
            List<BHistoryId> historyIdsToSend = this.updateTelemetryIds(historyIds, (HistorySpaceConnection)conn);
            if (historyIdsToSend.isEmpty()) {
                CompletableFuture<Integer> completableFuture2 = CompletableFuture.completedFuture(0);
                return completableFuture2;
            }
            Map<BHistoryId, BAbsTime> lastTimestamps = this.getLastTimestamps(historyIdsToSend);
            for (Map.Entry<BHistoryId, BAbsTime> entry : lastTimestamps.entrySet()) {
                BHistoryId historyId = entry.getKey();
                BAbsTime lastTs = entry.getValue();
                BIHistory history = conn.getHistory(historyId);
                BITable table = conn.timeQuery(history, lastTs.add(BRelTime.make((long)1L)), null);
                historyMap.put(historyId, table);
            }
            HistoryItemIterator historyItemIterator = new HistoryItemIterator(((BIHistoryChannelConfig)((Object)this.getChannelConfig())).getSystemId(), Collections.unmodifiableMap(historyMap), this.telemIdsByHistoryId);
            if (historyItemIterator.hasNext()) {
                completableFuture = this.sendHistoriesData(historyItemIterator);
                return completableFuture;
            }
            completableFuture = CompletableFuture.completedFuture(0);
            return completableFuture;
        }
    }

    public Map<BHistoryId, BAbsTime> getLastTimestamps(List<BHistoryId> historyIds) {
        Map<BHistoryId, BAbsTime> tsMap;
        BHistoryUpdateMode mode = ((BIHistoryChannelConfig)((Object)this.getChannelConfig())).getUpdateMode();
        switch (mode.getOrdinal()) {
            case 0: {
                log.finest("History Update Mode is set to Publish & Subscribe");
                BVector lastSent = this.getLastRecordSentTimes();
                tsMap = new HashMap();
                historyIds.stream().filter(hi -> lastSent.getSlot(EscUtil.slot.escape(hi.encodeToString())) != null).forEach(hi -> {
                    BAbsTime cfr_ignored_0 = (BAbsTime)tsMap.put((BHistoryId)hi, (BAbsTime)lastSent.get(EscUtil.slot.escape(hi.encodeToString())).as(BAbsTime.class));
                });
                break;
            }
            case 1: {
                log.finest("History Update Mode is set to Client & Server");
                Set<String> cloudIds = historyIds.stream().filter(h -> this.telemIdsByHistoryId.containsKey(h)).map(h -> this.telemIdsByHistoryId.get(h)).collect(Collectors.toSet());
                tsMap = cloudIds.isEmpty() ? new HashMap<BHistoryId, BAbsTime>() : this.getLastTimestampsData(cloudIds).join().getLastTimestamps().entrySet().stream().collect(Collectors.toMap(e -> this.historyIdsByTelemId.containsKey(e.getKey()) ? this.historyIdsByTelemId.get(e.getKey()) : BHistoryId.make((String)((String)e.getKey())), e -> (BAbsTime)e.getValue()));
                break;
            }
            default: {
                log.warning(() -> String.format("History Update Mode of %s is unknown.", mode.getOrdinal()));
                tsMap = Collections.emptyMap();
            }
        }
        historyIds.forEach(id -> tsMap.putIfAbsent((BHistoryId)id, BAbsTime.NULL));
        return tsMap;
    }

    public Cursor<BHistoryRecord> getHistories(BHistoryId historyId, BAbsTime start, BAbsTime end, boolean descending, int maxRecordCount, boolean requestPrevRecord, boolean requestNextRecord) {
        Cursor<BHistoryRecord> historiesCursor;
        Map<BHistoryId, Cursor<BHistoryRecord>> historiesMap = this.getHistoriesData(historyId, start, end, descending, maxRecordCount, requestPrevRecord, requestNextRecord).join().getHistoriesMap().get(((BIHistoryChannelConfig)((Object)this.getChannelConfig())).getSystemId());
        if (historiesMap != null && (historiesCursor = historiesMap.get(historyId)) != null) {
            return historiesCursor;
        }
        Context emptyContext = GetHistoriesResult.makeHistoryQueryResultCountContext(null, 0);
        return new EmptyCursor(emptyContext);
    }

    public BCompletableFutureWrapper doCloudIdsUpdated() {
        CompletableFuture<Object> resultFuture;
        BCloudHistoryAutoExportConfig autoExport = this.getExports().getAutoExport();
        autoExport.updateExcludedHistoryIdsVectors();
        stateLock.lock();
        try {
            if (BHistoryChannelState.backfillingIdentifying.equals((Object)this.state)) {
                this.setState(BHistoryChannelState.backfillingNeedsCheck);
                resultFuture = CompletableFuture.completedFuture(null);
            } else if (!BHistoryChannelState.identifying.equals((Object)this.state)) {
                log.fine("cloudId manager finished while in unexpected state " + (Object)((Object)this.state));
                resultFuture = new CompletableFuture();
                resultFuture.completeExceptionally(new IllegalStateException("cloudId update complete while in unexpected state " + (Object)((Object)this.state)));
            } else {
                this.setState(BHistoryChannelState.checkingBackfill);
                stateLock.unlock();
                resultFuture = this.doUpdateCloudIdsAndBackfill();
            }
        }
        finally {
            if (stateLock.isHeldByCurrentThread()) {
                stateLock.unlock();
            }
        }
        return BCompletableFutureWrapper.make(resultFuture);
    }

    public void notifyExportConfigEnabled() {
        stateLock.lock();
        try {
            if (BHistoryChannelState.normal.equals((Object)this.state)) {
                this.setState(BHistoryChannelState.checkingBackfill);
                stateLock.unlock();
                this.doUpdateCloudIdsAndBackfillAsync();
            } else if (BHistoryChannelState.checkingBackfill.equals((Object)this.state)) {
                this.updateBackfill.set(true);
            } else if (BHistoryChannelState.backfilling.equals((Object)this.state)) {
                this.setState(BHistoryChannelState.backfillingNeedsCheck);
            }
        }
        finally {
            if (stateLock.isHeldByCurrentThread()) {
                stateLock.unlock();
            }
        }
    }

    public Optional<BIHistory> getHistory(String telemetryId) {
        if (telemetryId == null || telemetryId.isEmpty()) {
            log.fine("getHistory() called with null or empty telemetryId");
            return Optional.empty();
        }
        BHistoryId historyId = this.historyIdsByTelemId.get(telemetryId);
        if (historyId == null) {
            try {
                historyId = BHistoryId.make((String)telemetryId);
            }
            catch (SyntaxException ex) {
                log.log(Level.FINE, "CloudId not found and unable to convert provided id into a historyId", ex);
                return Optional.empty();
            }
        }
        BHistoryDatabase historyDb = this.getHistoryDb();
        try (HistoryDatabaseConnection conn = historyDb.getDbConnection(null);){
            Optional<BIHistory> optional = Optional.ofNullable(conn.getHistory(historyId));
            return optional;
        }
    }

    public boolean getPaused() {
        return !BHistoryChannelState.normal.equals((Object)this.state);
    }

    protected void initializeTimestampData() {
        if (this.telemIdsByHistoryId.isEmpty() || ((BIHistoryChannelConfig)((Object)this.getChannelConfig())).getUpdateMode().equals((Object)BHistoryUpdateMode.ClientServer)) {
            this.setTimestampsInitialized();
            if (BHistoryChannelState.checkingBackfill.equals((Object)this.state)) {
                stateLock.lock();
                try {
                    this.setState(BHistoryChannelState.normal);
                }
                finally {
                    stateLock.unlock();
                }
            }
            return;
        }
        if (BHistoryChannelState.identifying.equals((Object)this.state)) {
            log.fine("not initializing timestamps when in pending state.");
            return;
        }
        CompletableFuture<GetLastTimestampsResult> future = this.getLastTimestampsData(this.telemIdsByHistoryId.values());
        this.scheduler.schedule(() -> future.completeExceptionally(new TimeoutException("get timestamps call timed out")), 1L, TimeUnit.MINUTES);
        future.whenCompleteAsync((result, err) -> {
            if (err != null) {
                if (this.initRetries++ < 5) {
                    try {
                        Thread.sleep((long)this.initRetries * 5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.initializeTimestampData();
                    return;
                }
                log.log(Level.WARNING, "Max retry attempt of Initialize Timestamp Data reached", log.isLoggable(Level.FINE) ? err : null);
                if (this.timestampInitializationFuture != null) {
                    this.timestampInitializationFuture.complete(null);
                    this.timestampInitializationFuture = null;
                }
            } else {
                BVector lastSent = this.getLastRecordSentTimes();
                for (Map.Entry<String, BAbsTime> entry : result.getLastTimestamps().entrySet()) {
                    try {
                        BHistoryId historyId = this.historyIdsByTelemId.get(entry.getKey());
                        String id = EscUtil.slot.escape(historyId != null ? historyId.encodeToString() : entry.getKey());
                        if (lastSent.getSlot(id) == null) {
                            lastSent.add(id, (BValue)entry.getValue());
                            continue;
                        }
                        lastSent.set(id, (BValue)entry.getValue());
                    }
                    catch (Exception ex) {
                        log.log(Level.INFO, "error updating timestamps", log.isLoggable(Level.FINE) ? ex : null);
                    }
                }
            }
            this.initRetries = 0;
            CompletionStage createBackfillFuture = null;
            try {
                if (this.needBackfill()) {
                    createBackfillFuture = this.createBackfill().whenComplete((backfillResult, backfillErr) -> this.setTimestampsInitialized());
                }
            }
            finally {
                if (createBackfillFuture == null) {
                    this.setTimestampsInitialized();
                }
            }
        }, (Executor)this.scheduler);
    }

    private void setTimestampsInitialized() {
        if (this.timestampInitializationFuture != null) {
            this.timestampInitializationFuture.complete(null);
            this.timestampInitializationFuture = null;
        }
        this.timestampsInitialized = true;
    }

    private CompletableFuture<Integer> sendHistoriesData(HistoryItemIterator historyItems) {
        this.checkChannelConfig(SEND_HISTORIES_ERROR, historyItems).ifPresent(errMsg -> {
            throw new IllegalStateException((String)errMsg);
        });
        BChannelConfig config = this.getChannelConfig();
        BAbstractTransport transport = config.getTransport(ISendHistoriesHandler.getOperationId());
        BAbstractCloudLinkHandlerFactory msgFactory = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service.")).getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        CompletableFuture<Integer> result = new CompletableFuture<Integer>();
        ISendHistoriesHandler messageHandler = msgFactory.getMessageHandler(ISendHistoriesHandler.class, config);
        HistoryItemBatchContainer batchContainer = new HistoryItemBatchContainer(config.getMaxMessageSize(ISendHistoriesHandler.getOperationId()), messageHandler::toMessage, messageHandler::add);
        ArrayList sendFutures = new ArrayList();
        HistoryBatchIterator<HistoryBatchWrapper> batches = new HistoryBatchIterator<HistoryBatchWrapper>(historyItems, batchContainer);
        batches.forEachRemaining(b -> {
            CompletableFuture resp = new CompletableFuture();
            CompletableFuture<IMessageResponse> requestFuture = messageHandler.getFuture(resp);
            MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(b.getMessage(), requestFuture, transport.getMessageRetries());
            AccessController.doPrivileged(() -> {
                config.enqueueMessage(ISendHistoriesHandler.getOperationId(), wrapper);
                return null;
            });
            if (resp.isCompletedExceptionally()) {
                resp.exceptionally(err -> {
                    if (err instanceof IOException && err.getMessage().contains("Transport Queue is full, try again later.") || err instanceof SecurityException) {
                        batches.abort();
                    }
                    return null;
                });
                sendFutures.add(resp);
                return;
            }
            transport.notifyPending();
            if (((BIHistoryChannelConfig)((Object)this.getChannelConfig())).getUpdateMode() == BHistoryUpdateMode.PubSub) {
                resp.whenComplete((response, err) -> {
                    if (err == null) {
                        BVector lastSent = this.getLastRecordSentTimes();
                        for (Map.Entry<String, BAbsTime> entry : b.getMessageLastTimes().entrySet()) {
                            String key = EscUtil.slot.escape(entry.getKey());
                            if (lastSent.getSlot(key) == null) {
                                lastSent.add(key, (BValue)entry.getValue());
                                continue;
                            }
                            if (((BAbsTime)lastSent.get(key).as(BAbsTime.class)).getMillis() >= entry.getValue().getMillis()) continue;
                            lastSent.set(key, (BValue)entry.getValue());
                        }
                    }
                });
            }
            sendFutures.add(resp);
        });
        CompletableFuture<Void> allReqs = CompletableFuture.allOf(sendFutures.toArray(CloudLinkConstants.EMPTY_COMP_FUTURE_ARRAY));
        allReqs.whenComplete((resp, err) -> {
            if (err != null) {
                result.completeExceptionally((Throwable)err);
            } else {
                int recordCount = sendFutures.stream().mapToInt(f -> ((SendHistoriesResult)f.join()).getRecordCount()).sum();
                result.complete(recordCount);
            }
        });
        return result;
    }

    protected CompletableFuture<GetLastTimestampsResult> getLastTimestampsData(Collection<String> historyIds) {
        CompletionStage<GetLastTimestampsResult> result = new CompletableFuture<GetLastTimestampsResult>();
        log.finest("Checking channel config before getting the last timestamps.");
        Optional<String> errMsg = this.checkChannelConfig(GET_LAST_TIMESTAMPS_ERROR, historyIds.iterator());
        if (errMsg.isPresent()) {
            result.completeExceptionally(new IllegalStateException(errMsg.get()));
            return result;
        }
        BAbstractTransport transport = this.getChannelConfig().getTransport(IGetLastTimestampsHandler.getOperationId());
        BAbstractCloudLinkHandlerFactory msgFactory = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service.")).getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        IGetLastTimestampsHandler messageHandler = msgFactory.getMessageHandler(IGetLastTimestampsHandler.class, this.getChannelConfig());
        int limit = ((BIHistoryChannelConfig)((Object)this.getChannelConfig())).getLastTimestampIdLimit();
        if (historyIds.size() <= limit) {
            this.sendHistoryIds(messageHandler, historyIds, true, (CompletableFuture<GetLastTimestampsResult>)result, transport);
        } else {
            int splitCount = (int)Math.ceil((double)historyIds.size() / (double)limit);
            CompletableFuture[] results = new CompletableFuture[splitCount];
            ArrayList<String> historyIdList = new ArrayList<String>();
            int count = 0;
            int futureId = 0;
            for (String id : historyIds) {
                historyIdList.add(id);
                if (++count % limit != 0) continue;
                results[futureId] = new CompletableFuture();
                this.sendHistoryIds(messageHandler, historyIdList, count == historyIds.size(), results[futureId++], transport);
                historyIdList.clear();
            }
            if (!historyIdList.isEmpty()) {
                results[futureId] = new CompletableFuture();
                this.sendHistoryIds(messageHandler, historyIdList, true, results[futureId], transport);
            }
            result = CompletableFuture.allOf(results).thenApply(v -> {
                CompositeGetLastTimestampsResult timestampsResult = new CompositeGetLastTimestampsResult();
                for (CompletableFuture res : results) {
                    timestampsResult.addLastTimestamps(((GetLastTimestampsResult)res.join()).getLastTimestamps());
                }
                return timestampsResult;
            });
        }
        transport.notifyPending();
        return result;
    }

    private void sendHistoryIds(IGetLastTimestampsHandler messageHandler, Collection<String> historyIds, boolean isFinal, CompletableFuture<GetLastTimestampsResult> result, BAbstractTransport transport) {
        messageHandler.add(historyIds);
        IMessage message = messageHandler.toMessage(isFinal);
        MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(message, messageHandler.getFuture(result, message), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            this.getChannelConfig().enqueueMessage(IGetLastTimestampsHandler.getOperationId(), wrapper);
            return null;
        });
    }

    private CompletableFuture<GetHistoriesResult> getHistoriesData(BHistoryId historyId, BAbsTime start, BAbsTime end, boolean descending, int maxRecordCount, boolean requestPrevRecord, boolean requestNextRecord) {
        CompletableFuture<GetHistoriesResult> result = new CompletableFuture<GetHistoriesResult>();
        Optional<String> errMsg = this.checkChannelConfig(GET_HISTORIES_ERROR, Collections.singleton(historyId).iterator());
        if (errMsg.isPresent()) {
            result.completeExceptionally(new IllegalStateException(errMsg.get()));
            return result;
        }
        BAbstractTransport transport = this.getChannelConfig().getTransport(IGetHistoriesHandler.getOperationId());
        BAbstractCloudLinkHandlerFactory msgHandlerFactory = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service.")).getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        IGetHistoriesHandler messageHandler = msgHandlerFactory.getMessageHandler(IGetHistoriesHandler.class, this.getChannelConfig());
        String cloudId = this.telemIdsByHistoryId.get(historyId);
        if (cloudId == null) {
            cloudId = historyId.encodeToString();
        }
        messageHandler.add(cloudId, start, end, descending, maxRecordCount, requestPrevRecord, requestNextRecord);
        MessageWrapper<IMessage> wrapper = new MessageWrapper<IMessage>(messageHandler.toMessage(true), messageHandler.getFuture(result), transport.getMessageRetries());
        AccessController.doPrivileged(() -> {
            this.getChannelConfig().enqueueMessage(IGetHistoriesHandler.getOperationId(), wrapper);
            return null;
        });
        transport.notifyPending();
        return result;
    }

    private Optional<String> checkChannelConfig(String prefix, Iterator<?> historyData) {
        StringBuilder err = this.checkChannelConfigCommon(prefix);
        if (historyData == null || !historyData.hasNext()) {
            if (err.length() > 0) {
                log.info(() -> String.format("%s: %s", err, NO_DATA));
                err.append(NO_DATA).append(';');
            } else {
                log.info(() -> String.format("%s: %s", prefix, NO_DATA));
                err.append(String.format("%s: %s", prefix, NO_DATA)).append(';');
            }
        }
        return err.length() > 0 ? Optional.of(err.substring(0, err.length() - 1)) : Optional.empty();
    }

    private void updateCloudIdsFromAllHistoryExports() {
        BCloudHistoryExportConfig[] configs;
        HashSet<BHistoryId> historyIdSet = new HashSet<BHistoryId>();
        for (BCloudHistoryExportConfig config : configs = (BCloudHistoryExportConfig[])this.getExports().getChildren(BCloudHistoryExportConfig.class)) {
            historyIdSet.addAll(config.getHistoryIdSet());
        }
        BHistoryDatabase histDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
        try (HistoryDatabaseConnection histDbConn = histDb.getDbConnection(null);){
            this.updateTelemetryIds(historyIdSet, (HistorySpaceConnection)histDbConn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<BHistoryId> updateTelemetryIds(Collection<BHistoryId> historyIds, HistorySpaceConnection conn) {
        Object object = this.updateTelemetryIdsSyncObject;
        synchronized (object) {
            ArrayList<BHistoryId> mappedHistoryIds = new ArrayList<BHistoryId>();
            for (BHistoryId historyId : historyIds) {
                this.updateTelemetryId(historyId, conn).ifPresent(ignored -> mappedHistoryIds.add(historyId));
            }
            return mappedHistoryIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> updateTelemetryId(BHistoryId historyId, HistorySpaceConnection historyDbConn) {
        Object object = this.updateTelemetryIdsSyncObject;
        synchronized (object) {
            String rv;
            if (!historyDbConn.exists(historyId)) {
                String telemetryId = this.telemIdsByHistoryId.remove(historyId);
                if (telemetryId != null) {
                    this.historyIdsByTelemId.remove(telemetryId);
                }
                log.warning(() -> String.format("History does not exist for historyId %s", historyId.encodeToString()));
                return Optional.empty();
            }
            String telemetryId = historyId.encodeToString();
            if (this.telemIdsByHistoryId.containsKey(historyId) && !telemetryId.equals(rv = this.telemIdsByHistoryId.get(historyId))) {
                return Optional.of(rv);
            }
            Optional optTelemetryId = this.getConnectionService().flatMap(ccs -> ccs.getCloudIdManager().getTelemetryId(historyId));
            if (optTelemetryId.isPresent()) {
                telemetryId = (String)optTelemetryId.get();
                Object licenseFault = this.getConnectionService().get().fw(501, historyId, telemetryId, null, null);
                if (licenseFault != null) {
                    liclog.warning("Histories Channel License fault: " + licenseFault);
                    licdbg.fine(() -> String.format("License count exceeded for history with historyId %s and telemetryId %s", historyId, optTelemetryId.get()));
                    return Optional.empty();
                }
                licdbg.fine(() -> String.format("License ok for history with historyId %s and telemetryId %s", historyId, optTelemetryId.get()));
                this.telemIdsByHistoryId.put(historyId, telemetryId);
                this.historyIdsByTelemId.put(telemetryId, historyId);
                BCloudHistoryAutoExportConfig autoExport = this.getExports().getAutoExport();
                autoExport.removeExclusion(historyId, 4);
                return Optional.of(telemetryId);
            }
            BCloudHistoryAutoExportConfig autoExport = this.getExports().getAutoExport();
            autoExport.excludeHistoryId(historyId, 4);
            return Optional.empty();
        }
    }

    protected BHistoryDatabase getHistoryDb() {
        BHistoryService historyService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        return historyService.getDatabase();
    }

    protected CompletableFuture<Void> doUpdateCloudIdsAndBackfill() {
        this.updateCloudIdsFromAllHistoryExports();
        CompletionStage<Object> resultFuture = this.needBackfill() ? this.createBackfill().whenComplete((result, err) -> {
            if (err != null) {
                log.log(Level.FINE, "Backfill failed during doUpdateCloudIdsAndBackfill", (Throwable)err);
            }
        }) : CompletableFuture.completedFuture(null);
        return resultFuture;
    }

    protected void doUpdateCloudIdsAndBackfillAsync() {
        this.scheduler.execute(this::doUpdateCloudIdsAndBackfill);
    }

    /*
     * Exception decompiling
     */
    protected boolean needBackfill() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 35[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setBackfillState(BAbsTime start) {
        log.fine(() -> "needBackfill finished in " + (BAbsTime.now().getMillis() - start.getMillis()) + "ms");
        stateLock.lock();
        try {
            this.setState(BHistoryChannelState.backfilling);
        }
        finally {
            stateLock.unlock();
        }
    }

    protected CompletableFuture<Void> createBackfill() {
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        BChannelConfig config = this.getChannelConfig();
        if (!this.isOperational()) {
            ((BIHistoryChannelConfig)((Object)config)).setBackfillStatus(lex.getText("history.backfill.failed", new Object[]{BAbsTime.now().encodeToString()}));
            log.warning("Histories channel cannot create backfill as it is not operational");
            resultFuture.completeExceptionally(new Exception("Histories channel cannot create backfill as it is not operational"));
            return resultFuture;
        }
        BVector lastSentTimes = this.getLastRecordSentTimes();
        BHistoryDatabase historyDb = this.getHistoryDb();
        if (historyDb == null) {
            ((BIHistoryChannelConfig)((Object)config)).setBackfillStatus(lex.getText("history.backfill.failed", new Object[]{BAbsTime.now().encodeToString()}));
            log.warning("need backfill: unable to get history db.");
            resultFuture.completeExceptionally(new Exception("unable to get history db"));
            return resultFuture;
        }
        Optional optUploader = this.getConnectionService().flatMap(c -> c.getFileUploader(this));
        if (!optUploader.isPresent()) {
            ((BIHistoryChannelConfig)((Object)config)).setBackfillStatus(lex.getText("history.backfill.failed", new Object[]{BAbsTime.now().encodeToString()}));
            log.warning("need backfill: unable to get file uploader.");
            resultFuture.completeExceptionally(new Exception("unable to get file uploader"));
            return resultFuture;
        }
        FileUploader uploader = (FileUploader)optUploader.get();
        BAbstractTransport transport = config.getTransport(ISendBulkHistoriesHandler.getOperationId());
        BAbstractCloudLinkHandlerFactory msgFactory = this.getConnectionService().orElseThrow(() -> new IllegalStateException("Unable to locate Cloud Connection Service.")).getMessageHandlerFactory(this.getPlatformType(), transport.getTransportType()).orElseThrow(() -> new IllegalStateException("Unable to locate message handler factory."));
        ArrayList futureList = new ArrayList();
        log.info("Performing history records backfill. It may take a while to upload all the records. Wait for the backfill to complete.");
        try (ISendBulkHistoriesHandler messageHandler = msgFactory.getMessageHandler(ISendBulkHistoriesHandler.class, config);){
            String systemId = ((BIHistoryChannelConfig)((Object)config)).getSystemId();
            HashMap<Object, Object> lastTimes = new HashMap<BHistoryId, BAbsTime>();
            try (HistoryDatabaseConnection conn = historyDb.getDbConnection(null);){
                BCloudHistoryExportConfig[] exports;
                for (BCloudHistoryExportConfig export : exports = (BCloudHistoryExportConfig[])this.getExports().getChildren(BCloudHistoryExportConfig.class)) {
                    if (!export.getEnabled()) continue;
                    ((BIHistoryChannelConfig)((Object)config)).setBackfillStatus(lex.getText("history.backfill.creating.start", new Object[]{export.getName()}));
                    log.info(String.format("Processing export config %s for history backfill", export.getName()));
                    int currentHistoryIdNumber = 0;
                    Set<BHistoryId> historyIdSet = export.getHistoryIdSet();
                    for (BHistoryId historyId : historyIdSet) {
                        String cloudId;
                        if (++currentHistoryIdNumber % 1000 == 0) {
                            int finalCurrentHistoryIdNumber = currentHistoryIdNumber;
                            log.finest(() -> String.format("Processing history %d of %d for export config %s backfill", finalCurrentHistoryIdNumber, historyIdSet.size(), export.getName()));
                        }
                        if ((cloudId = this.telemIdsByHistoryId.get(historyId)) == null) continue;
                        BITable<BHistoryRecord> table = BHistoriesChannel.getHistoryTable(lastSentTimes, conn, historyId);
                        try {
                            TableCursor cursor = table.cursor();
                            BAbsTime lastTimestamp = BAbsTime.DEFAULT;
                            for (BHistoryRecord rec : cursor) {
                                HistoryItem item = new HistoryItem(systemId, historyId, rec);
                                lastTimestamp = rec.getTimestamp();
                                int fileSize = messageHandler.add(new HistoryItemWrapper(item, cloudId));
                                if (fileSize < config.getMaxMessageSize(ISendBulkHistoriesHandler.getOperationId())) continue;
                                lastTimes.put(historyId, lastTimestamp);
                                futureList.add(this.sendBulkHistoryFile(messageHandler, uploader, lastTimes, false));
                                lastTimes = new HashMap();
                            }
                            cursor.close();
                            lastTimes.put(historyId, lastTimestamp);
                        }
                        catch (HistoryException ex) {
                            log.log(Level.INFO, "Error backfilling history records for " + historyId.encodeToString(), log.isLoggable(Level.FINE) ? ex : null);
                        }
                    }
                    ((BIHistoryChannelConfig)((Object)config)).setBackfillStatus(lex.getText("history.backfill.creating.finish", new Object[]{export.getName()}));
                    log.info(String.format("Finished processing export config %s for history backfill", export.getName()));
                }
                if (messageHandler.hasData()) {
                    futureList.add(this.sendBulkHistoryFile(messageHandler, uploader, lastTimes, true));
                }
            }
        }
        catch (Exception e) {
            futureList.forEach(f -> f.cancel(true));
            futureList.clear();
            CompletableFuture extFut = new CompletableFuture();
            extFut.completeExceptionally(e);
            futureList.add(extFut);
        }
        ((BIHistoryChannelConfig)((Object)config)).setBackfillStatus(lex.getText("history.backfill.uploading"));
        resultFuture = CompletableFuture.allOf(futureList.toArray(CloudLinkConstants.EMPTY_COMP_FUTURE_ARRAY));
        resultFuture.whenComplete((result, err) -> {
            if (err != null) {
                ((BIHistoryChannelConfig)((Object)config)).setBackfillStatus(lex.getText("history.backfill.failed", new Object[]{BAbsTime.now().encodeToString()}));
                log.log(Level.WARNING, "History records backfill failed", log.isLoggable(Level.FINE) ? err : null);
            } else {
                ((BIHistoryChannelConfig)((Object)config)).setBackfillStatus(lex.getText("history.backfill.completed", new Object[]{BAbsTime.now().encodeToString()}));
                log.info("History records backfill completed successfully");
            }
            stateLock.lock();
            try {
                if (err != null && !this.backfillError) {
                    this.backfillError = true;
                    this.setState(BHistoryChannelState.checkingBackfill);
                    stateLock.unlock();
                    this.doUpdateCloudIdsAndBackfillAsync();
                } else {
                    this.backfillError = false;
                    if (BHistoryChannelState.backfillingIdentifying.equals((Object)this.state)) {
                        this.setState(BHistoryChannelState.identifying);
                    } else if (BHistoryChannelState.backfillingNeedsCheck.equals((Object)this.state)) {
                        this.setState(BHistoryChannelState.checkingBackfill);
                        stateLock.unlock();
                        this.doUpdateCloudIdsAndBackfillAsync();
                    } else if (BHistoryChannelState.backfilling.equals((Object)this.state)) {
                        this.setState(BHistoryChannelState.normal);
                    } else {
                        log.fine("backfill completed while in unexpected state " + this.state.getTag());
                    }
                }
            }
            finally {
                if (stateLock.isHeldByCurrentThread()) {
                    stateLock.unlock();
                }
            }
        });
        return resultFuture;
    }

    private static BITable<BHistoryRecord> getHistoryTable(BVector lastSentTimes, HistoryDatabaseConnection conn, BHistoryId historyId) {
        BValue value = lastSentTimes.get(EscUtil.slot.escape(historyId.encodeToString()));
        BAbsTime lastTs = BAbsTime.DEFAULT;
        if (value instanceof BAbsTime) {
            lastTs = (BAbsTime)value;
        }
        BIHistory history = conn.getHistory(historyId);
        return conn.timeQuery(history, lastTs.add(BRelTime.make((long)1L)), null);
    }

    private CompletableFuture<Void> sendBulkHistoryFile(ISendBulkHistoriesHandler messageHandler, FileUploader uploader, Map<BHistoryId, BAbsTime> fileLastTimes, boolean isFinal) {
        CompletableFuture<Void> lastSentTimesUpdated;
        CompletableFuture<SendHistoriesResult> channelFuture = new CompletableFuture<SendHistoriesResult>();
        if (!this.isOperational()) {
            log.fine("Histories channel cannot send bulk history file because it is not operational");
            CompletableFuture<Void> lastSentTimesUpdated2 = new CompletableFuture<Void>();
            lastSentTimesUpdated2.completeExceptionally(new RuntimeException("Histories channel cannot send bulk history file because it is not operational"));
            return lastSentTimesUpdated2;
        }
        IMessage msg = messageHandler.toMessage(isFinal);
        if (msg == null) {
            messageHandler.getFuture(channelFuture, msg);
            lastSentTimesUpdated = this.updateLastSentTimesWhenComplete(fileLastTimes, channelFuture);
        } else if (msg instanceof FileUploadRequest) {
            CompletableFuture<IMessageResponse> messageFuture = messageHandler.getFuture(channelFuture, msg);
            lastSentTimesUpdated = this.updateLastSentTimesWhenComplete(fileLastTimes, channelFuture);
            log.finer(() -> String.format("Uploading history backfill file  %s", ((FileUploadRequest)msg).getFileName()));
            uploader.upload((FileUploadRequest)msg).whenComplete((result, err) -> {
                if (err != null) {
                    messageFuture.completeExceptionally((Throwable)err);
                } else {
                    messageFuture.complete(null);
                }
            });
        } else {
            lastSentTimesUpdated = new CompletableFuture();
            lastSentTimesUpdated.completeExceptionally(new Exception("Unable to generate upload request."));
        }
        return lastSentTimesUpdated;
    }

    private CompletableFuture<Void> updateLastSentTimesWhenComplete(Map<BHistoryId, BAbsTime> fileLastTimes, CompletableFuture<SendHistoriesResult> future) {
        CompletableFuture<Void> lastSentTimesUpdated = new CompletableFuture<Void>();
        future.whenComplete((result, err) -> {
            if (err != null) {
                lastSentTimesUpdated.completeExceptionally((Throwable)err);
                return;
            }
            BVector lastSentTimes = this.getLastRecordSentTimes();
            for (Map.Entry ltEntry : fileLastTimes.entrySet()) {
                String key = EscUtil.slot.escape(((BHistoryId)ltEntry.getKey()).encodeToString());
                if (lastSentTimes.getSlot(key) == null) {
                    lastSentTimes.add(key, (BValue)ltEntry.getValue());
                    continue;
                }
                if (((BAbsTime)lastSentTimes.get(key).as(BAbsTime.class)).getMillis() >= ((BAbsTime)ltEntry.getValue()).getMillis()) continue;
                lastSentTimes.set(key, (BValue)ltEntry.getValue());
            }
            lastSentTimesUpdated.complete(null);
        });
        return lastSentTimesUpdated;
    }

    public CompletableFuture<Integer> sendHistoriesFailureMessage(String errorMessage) {
        CompletableFuture<Integer> result = new CompletableFuture<Integer>();
        result.completeExceptionally(new Exception(errorMessage));
        return result;
    }

    private void registerCallbacks() {
        this.getConnectionService().ifPresent(ccs -> {
            ccs.getCloudIdManager().registerCallbacks(this);
            this.linkTo((BComponent)ccs.getCloudIdManager(), (Slot)BCloudIdManager.newCloudIdsAssigned, (Slot)cloudIdsUpdated);
        });
        BAbstractTransport transport = this.getChannelConfig().getTransport(ISendHistoriesHandler.getOperationId());
        if (transport instanceof BAbstractConnectedTransport) {
            BAbstractConnectedTransport connectedTransport = (BAbstractConnectedTransport)transport;
            connectedTransport.addConnectionCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnect() {
        stateLock.lock();
        try {
            if (this.disconnectTime != null) {
                long disconnectMillis = BAbsTime.now().getMillis() - this.disconnectTime.getMillis();
                this.disconnectTime = null;
                BIHistoryChannelConfig channelConfig = (BIHistoryChannelConfig)((Object)this.getChannelConfig());
                if (disconnectMillis > channelConfig.getBackfillReconnectMinTime().getMillis() && this.isOperational() && BHistoryChannelState.normal.equals((Object)this.state)) {
                    this.setState(BHistoryChannelState.checkingBackfill);
                    stateLock.unlock();
                    this.doUpdateCloudIdsAndBackfillAsync();
                }
            }
        }
        finally {
            if (stateLock.isHeldByCurrentThread()) {
                stateLock.unlock();
            }
        }
    }

    @Override
    public void onDisconnect() {
        if (this.disconnectTime == null) {
            this.disconnectTime = BAbsTime.now();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void beginNewIds() {
        stateLock.lock();
        try {
            switch (this.state.getOrdinal()) {
                case 3: 
                case 7: {
                    this.setState(BHistoryChannelState.identifying);
                    return;
                }
                case 4: 
                case 6: {
                    this.setState(BHistoryChannelState.backfillingIdentifying);
                    return;
                }
            }
            return;
        }
        finally {
            stateLock.unlock();
        }
    }

    private void setState(BHistoryChannelState newState) {
        if (!stateLock.isHeldByCurrentThread()) {
            log.config(() -> String.format("attempting to set state without lock old state %s, new state %s", this.state.getTag(), newState.getTag()));
            return;
        }
        log.finer(() -> String.format("setting state from %s to %s", this.state.getTag(), newState.getTag()));
        this.state = newState;
        this.setDisplayState(this.state.getDisplayTag(null));
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("BHistoriesChannel");
        out.prop((Object)"timestampsInitialized", this.timestampsInitialized);
        stateLock.lock();
        try {
            out.prop((Object)"backfillError", this.backfillError);
        }
        finally {
            if (stateLock.isHeldByCurrentThread()) {
                stateLock.unlock();
            }
        }
        out.prop((Object)"initRetries", this.initRetries);
        out.prop((Object)"scheduler", (Object)this.scheduler);
        out.prop((Object)"disconnectTime", (Object)this.disconnectTime);
        out.prop((Object)"state", (Object)this.state);
        out.prop((Object)"updateBackfill", (Object)this.updateBackfill);
        out.prop((Object)"historyIdsByTelemId Map size", this.historyIdsByTelemId.size());
        out.prop((Object)"telemIdsByHistoryId Map size", this.telemIdsByHistoryId.size());
        out.endProps();
        super.spy(out);
        out.startProps("History and Telemetry Mapping Tables");
        out.trTitle((Object)"History IDs by Telemetry ID Map", 2);
        this.historyIdsByTelemId.forEach((k, v) -> out.prop(k, v));
        out.trTitle((Object)"Telemetry IDs by History ID Map", 2);
        this.telemIdsByHistoryId.forEach((k, v) -> out.prop(k, v));
        out.endProps();
    }

    private static /* synthetic */ String lambda$needBackfill$42(BAbsTime start) {
        return "needBackfill finished in " + (BAbsTime.now().getMillis() - start.getMillis()) + "ms";
    }

    private /* synthetic */ String lambda$needBackfill$41() {
        return String.format("in needBackfill with state %s", this.state.getDisplayTag(null));
    }
}

